#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import sys
import logging
from optparse import OptionParser

from ksscommand import KssCommand, KssCommandOptException

import __cmd__

try:
    import karesansui
    from karesansui import __version__
    from karesansui.lib.virt.virt import KaresansuiVirtConnection
    from karesansui.lib.utils import load_locale
except ImportError:
    print >>sys.stderr, "[Error] karesansui package was not found."
    sys.exit(1)

_ = load_locale()

usage = '%prog [options]'

def getopts():
    optp = OptionParser(usage=usage, version=__version__)
    optp.add_option('-n', '--name', dest='name', help=_('Domain Name'))
    optp.add_option('-f', '--from', dest='old', help=_('Original MAC address'))
    optp.add_option('-t', '--to', dest='new', help=_('New MAC address'))
    return optp.parse_args()

def chkopts(opts):
    if not opts.name:
        raise KssCommandOptException('ERROR: %s option is required.' % '-n or --name')
    if not opts.old:
        raise KssCommandOptException('ERROR: %s option is required.' % '-f or --from')
    if not opts.new:
        raise KssCommandOptException('ERROR: %s option is required.' % '-t or --to')

class SetMAC(KssCommand):

    def process(self):
        (opts, args) = getopts()
        chkopts(opts)
        self.up_progress(10)

        conn = KaresansuiVirtConnection(readonly=False)
        try:
            conn.set_domain_name(opts.name)
            self.up_progress(10)
            conn.guest.modify_mac_address(opts.old,opts.new)
            self.up_progress(40)
            self.logger.info('Set MAC address. - dom=%s from=%s to=%s' % (opts.name,opts.old, opts.new))
            print >>sys.stdout, _('Set MAC address. - dom=%s from=%s to=%s') % (opts.name, opts.old, opts.new)
            return True

        finally:
            conn.close()

if __name__ == "__main__":
    target = SetMAC()
    sys.exit(target.run())
