/*
 * This file is part of Karesansui.
 *
 * random_entropy.c
 * Copyright (C) 2009-2010 HDE, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include "Python.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <asm/types.h>
#include <linux/random.h>
#include <unistd.h>

#define VERSION "0.1"
#define DEV_RANDOM    "/dev/random"
#define ENTROPY_AVAIL "/proc/sys/kernel/random/entropy_avail"

int get_entropy_avail(void);

static PyObject *reGetVersion (PyObject *self, PyObject *args) {
    return Py_BuildValue("s", VERSION);
}

static PyObject *reGetEntropyAvail (PyObject *self, PyObject *args) {
    int retval;

    retval = get_entropy_avail();
    return Py_BuildValue("i", retval);
}

static PyObject *reAppendEntropy(PyObject *self, PyObject *args) {
  int count;
  struct rand_pool_info *output;
  int retval;
  int fd;

  if(! PyArg_ParseTuple(args, "i", & count))
    return(NULL);

  if(count < 1 || count > 9999){
    PyErr_SetString(PyExc_RuntimeError, "entropy count must be in 1..9999");
    return(NULL);
  }

  fd = open(DEV_RANDOM, O_WRONLY);
  output = (struct rand_pool_info *)malloc(10000);
  output->entropy_count = count;
  output->buf_size = 8000;

  retval = ioctl(fd, RNDADDENTROPY, output);
  if(retval == 0) {
    retval = get_entropy_avail();
  }
  return Py_BuildValue("i", retval);
}

int get_entropy_avail() {
  char entropy_avail[10];
  FILE *fp;
  int retval = -1;

  if( NULL != (fp = fopen(ENTROPY_AVAIL, "r"))) {
    if( NULL != fgets(entropy_avail, sizeof(entropy_avail), fp)) {
      retval = atoi(entropy_avail);
    }
    fclose(fp);
  }
  return retval;
}

static PyMethodDef MethodsDefs[] = {
  {"version",         reGetVersion,      METH_VARARGS, NULL},
  {"getEntropyAvail", reGetEntropyAvail, METH_VARARGS, NULL},
  {"appendEntropy",   reAppendEntropy,   METH_VARARGS, NULL},
  {NULL, NULL, 0},
};

void initrandom_entropy(void){
  (void) Py_InitModule("random_entropy", MethodsDefs);
}
/* end. */
