#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

"""<comment-ja>
Karesansui独自の認証
</comment-ja>
<comment-en>
TODO: English Documents(en)
</comment-en>
"""

import os
from base64 import b64decode

import web

from karesansui.lib.rest import mako_translation
from karesansui.db.access.user import login as dba_login
from karesansui.lib.const import LOGOUT_FILE_PREFIX

def auth(func):
    """<comment-ja>
    Basic認証を行います。
      - 認証方式はDB認証
        - 認証に失敗した場合は、401 Unauthorizedなります。
        - 認証に成功すると、呼出元のクラスに me,languages,_ がセットされます。
          - me: ログインユーザ情報が設定されます。(karesansui.db.user.User)
          - languages: locale情報が設定されます。(左から評価されます)
          - _: 国際化メソッドが設定されます。( 使い方 : _('hoge') )
    </comment-ja>
    <comment-en>
    TODO: English Comment
    </comment-en>
    """
    def wrapper(self, *args, **kwargs):
        # -- Basic Auth
        def __login():
            """<comment-ja>
            ログインチェックを行います。
            @return: ログインユーザ情報
            </comment-ja>
            <comment-en>
            TODO: English Comment
            </comment-en>
            """
            _http_auth = web.ctx.env['HTTP_AUTHORIZATION'].strip()
            if _http_auth[:5] == 'Basic':
                email, password = b64decode(_http_auth[6:].strip()).split(':')
                session = web.ctx.orm
                user = dba_login(session, unicode(email), unicode(password))
                return (user, email)

        if web.ctx.env.has_key('HTTP_AUTHORIZATION'):
            (user, email) = __login()

            if user:
                self.me = user

                # Logout
                fname = '%s%s' % (LOGOUT_FILE_PREFIX, self.me.email,)
                if os.access(fname, os.F_OK):
                    os.unlink(fname)
                    return web.unauthorized()

                # Login: Success
                if user.languages in self.languages:
                    x = self.languages.index(user.languages)
                    self.languages.pop(x)

                self.languages.insert(0, user.languages)
                self.logger.info('user_id=%s,lang=%s : Method=%s - Basic Authentication=Success' %
                                  (self.me.id, ','.join(self.languages), self.__method__))

                # __init__#self._ update!!
                self._ = mako_translation(languages=self.languages)
                return func(self, *args, **kwargs)
            else:
                 # Login: Failure
                self.logger.info('user=%s : Method=%s - Basic Authentication=Failure' %
                                  (email, self.__method__))
                return web.unauthorized()
        else:
            # Login: Anonymous
            self.logger.info('user=anonymous : Method=%s - Basic Authentication=Anonymous' %
                              (self.__method__))
            return web.unauthorized()

    wrapper.__name__ = func.__name__
    wrapper.__dict__ = func.__dict__
    wrapper.__doc__ = func.__doc__
    return wrapper
