#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
sys.path.append('/opt/hde/lib/python/')
import rrdtool

from rrd_const import RRD_DIR, START_TIME, END_TIME

dev = "hda"

data = rrdtool.graph('disk_merged_graph.gif',
                     "--font", "DEFAULT:0:IPAexGothic",
                     "--title", "disk-" + dev + "/disk_merged",
                     "--vertical-label", "Merged Ops/s",
                     "--lower-limit", "0",
                     "--rigid",
                     "--width", "500",
                     "--height", "200",
                     "--start", START_TIME,
                     "--end",  END_TIME,
#                     "--legend-direction", "bottomup",
                     "DEF:merged_read=" + RRD_DIR + "disk-" + dev + "/disk_merged.rrd:read:AVERAGE",
                     "DEF:merged_write=" + RRD_DIR + "disk-" + dev + "/disk_merged.rrd:write:AVERAGE",
                     "AREA:merged_read#44FF44:Read",
                     "GPRINT:merged_read:MIN:%6.2lf%s Min, ",
                     "GPRINT:merged_read:MAX:%6.2lf%s Max, ",
                     "GPRINT:merged_read:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:merged_read:LAST:%6.2lf%s Last\\n",
                     "STACK:merged_write#4444FF:Write",
                     "GPRINT:merged_write:MIN:%6.2lf%s Min, ",
                     "GPRINT:merged_write:MAX:%6.2lf%s Max, ",
                     "GPRINT:merged_write:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:merged_write:LAST:%6.2lf%s Last\\n",
                     "LINE1:merged_read#00FF",
                     "STACK:merged_write#0000FF",
                     )

data = rrdtool.graph('disk_octets_graph.gif',
                     "--font", "DEFAULT:0:IPAexGothic",
                     "--title", "disk-" + dev + "/disk_octets",
                     "--vertical-label", "Byte/s",
                     "--lower-limit", "0",
                     "--rigid",
                     "--width", "500",
                     "--height", "200",
                     "--start", START_TIME,
                     "--end",  END_TIME,
#                     "--legend-direction", "bottomup",
                     "DEF:octets_read=" + RRD_DIR + "disk-" + dev + "/disk_octets.rrd:read:AVERAGE",
                     "DEF:octets_write=" + RRD_DIR + "disk-" + dev + "/disk_octets.rrd:write:AVERAGE",
                     "AREA:octets_read#44FF44:Read",
                     "GPRINT:octets_read:MIN:%6.2lf%s Min, ",
                     "GPRINT:octets_read:MAX:%6.2lf%s Max, ",
                     "GPRINT:octets_read:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:octets_read:LAST:%6.2lf%s Last\\n",
                     "STACK:octets_write#4444FF:Write",
                     "GPRINT:octets_write:MIN:%6.2lf%s Min, ",
                     "GPRINT:octets_write:MAX:%6.2lf%s Max, ",
                     "GPRINT:octets_write:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:octets_write:LAST:%6.2lf%s Last\\n",
                     "LINE1:octets_read#00FF",
                     "STACK:octets_write#0000FF",
                     )

data = rrdtool.graph('disk_ops_graph.gif',
                     "--font", "DEFAULT:0:IPAexGothic",
                     "--title", "disk-" + dev + "/disk_ops",
                     "--vertical-label", "Ops/s",
                     "--lower-limit", "0",
                     "--rigid",
                     "--width", "500",
                     "--height", "200",
                     "--start", START_TIME,
                     "--end",  END_TIME,
#                     "--legend-direction", "bottomup",
                     "DEF:ops_read=" + RRD_DIR + "disk-" + dev + "/disk_ops.rrd:read:AVERAGE",
                     "DEF:ops_write=" + RRD_DIR + "disk-" + dev + "/disk_ops.rrd:write:AVERAGE",
                     "AREA:ops_read#44FF44:Read",
                     "GPRINT:ops_read:MIN:%6.2lf%s Min, ",
                     "GPRINT:ops_read:MAX:%6.2lf%s Max, ",
                     "GPRINT:ops_read:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:ops_read:LAST:%6.2lf%s Last\\n",
                     "STACK:ops_write#4444FF:Write",
                     "GPRINT:ops_write:MIN:%6.2lf%s Min, ",
                     "GPRINT:ops_write:MAX:%6.2lf%s Max, ",
                     "GPRINT:ops_write:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:ops_write:LAST:%6.2lf%s Last\\n",
                     "LINE1:ops_read#00FF",
                     "STACK:ops_write#0000FF",
                     )

data = rrdtool.graph('disk_time_graph.gif',
                     "--font", "DEFAULT:0:IPAexGothic",
                     "--title", "disk-" + dev + "/disk_time",
                     "--vertical-label", "Seconds/s",
                     "--lower-limit", "0",
                     "--rigid",
                     "--width", "500",
                     "--height", "200",
                     "--start", START_TIME,
                     "--end",  END_TIME,
#                     "--legend-direction", "bottomup",
                     "DEF:time_read=" + RRD_DIR + "disk-" + dev + "/disk_time.rrd:read:AVERAGE",
                     "DEF:time_write=" + RRD_DIR + "disk-" + dev + "/disk_time.rrd:write:AVERAGE",
                     "AREA:time_read#44FF44:Read",
                     "GPRINT:time_read:MIN:%6.2lf%s Min, ",
                     "GPRINT:time_read:MAX:%6.2lf%s Max, ",
                     "GPRINT:time_read:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:time_read:LAST:%6.2lf%s Last\\n",
                     "STACK:time_write#4444FF:Write",
                     "GPRINT:time_write:MIN:%6.2lf%s Min, ",
                     "GPRINT:time_write:MAX:%6.2lf%s Max, ",
                     "GPRINT:time_write:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:time_write:LAST:%6.2lf%s Last\\n",
                     "LINE1:time_read#00FF",
                     "STACK:time_write#0000FF",
                     )

