# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import socket

import web

from karesansui.lib.rest import Rest, auth

from karesansui.db.access.machine import findbyhost1
from karesansui.lib.utils import is_param, host2ip
from karesansui.lib.conf import read_conf, write_conf

from karesansui.lib.checker import Checker, \
    CHECK_EMPTY, CHECK_VALID, CHECK_LENGTH

def validates_ntp(obj):
    checker = Checker()
    check = True
    _ = obj._
    checker.errors = []

    obj.view.alert = checker.errors
    return check

class HostBy1Ntp(Rest):

    @auth
    def _GET(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        self.view.host_id = host_id

        modules = ["ntp"]

        host = findbyhost1(self.orm, host_id)
        dop = read_conf(modules, self, host)
        if dop is False:
            return web.internalerror('Internal Server Error. (Timeout)')

        ntp_server    = dop.get("ntp", ["server"])

        if ntp_server is False:
            ntp_server = []

        if type(ntp_server) == str:
            ntp_server = [ntp_server]

        if self.is_mode_input() is True:
            self.view.ntp_server = "\n".join(ntp_server)
        else:
            self.view.ntp_server = ntp_server

        return True

    @auth
    def _PUT(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        if not validates_ntp(self):
            self.logger.debug("Change time failed. Did not validate.")
            return web.badrequest(self.view.alert)

        modules = ["ntp"]

        host = findbyhost1(self.orm, host_id)
        dop = read_conf(modules, self, host)
        if dop is False:
            self.logger.error("Change time setting failed. Failed read conf.")
            return web.internalerror('Internal Server Error. (Read Conf)')

        ntp_servers = self.input.ntp_server.strip().split()

        dop.set("ntp"  ,["restrict"] , [])
        new_restrict = [
            'default ignore', 
            "-6 default ignore",
            "127.0.0.1",
            "-6 ::1",
        ]
        restrict_options = "mask 255.255.255.255 nomodify notrap noquery"
        for ntp_server in ntp_servers:
            if ntp_server == '127.127.1.0':
                continue

            ipaddrs = host2ip(ntp_server)
            for ipaddr in ipaddrs:
                new_restrict.append("%s %s" % (ipaddr, restrict_options))
        dop.set("ntp"  ,["restrict"] , new_restrict)

        dop.set("ntp"  ,["server"] , ntp_servers)

        retval = write_conf(dop, self, host)
        if retval is False:
            self.logger.error("Change time failed. Failed write conf.")
            return web.internalerror('Internal Server Error. (Write Conf)')

        return web.accepted(url=web.ctx.path)

urls = (
    '/host/(\d+)/ntp/?(\.part)?$', HostBy1Ntp
    )
