#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

import os
import re
import sys
import copy

from karesansui.lib.file.configfile import iniConfigFile
from karesansui.lib.dict_op import DictOp

class iniConfParser:

    _start_section       = "["
    _end_section         = "]"
    _delim               = "="
    _new_delim           = "="
    _reserved_key_prefix = "@"

    _module      = "ini_conf_parser"

    def __init__(self,paths=[]):
        self.dop = DictOp()
        self.dop.addconf(self._module,{})
        self.set_source_file(paths)

    def set_reserved_key_prefix(self, prefix="@"):
        self._reserved_key_prefix = prefix

    def set_source_file(self,paths=[]):
        if type(paths) == str:
            paths = [paths]
        self.paths = paths
        return True

    def get_start_section(self):
        return self._start_section

    def get_end_section(self):
        return self._end_section

    def get_source_file(self):
        return self.paths

    def source_file(self):
        return self.get_source_file()

    def read_conf(self):
        retval = {}

        for _afile in self.source_file():
            for section, items in iniConfigFile(_afile).read():
                for key, value in items:
                    self.dop.set(self._module,[_afile, section, key], value)

        #self.dop.preprint_r(self._module)
        return self.dop.getconf(self._module)


    def _value_to_lines(self,value):
        lines = []

        for _k,_v in value.iteritems():

            try:
                if _v['action'] == "delete":
                    continue
            except:
                pass

            try:
                val = _v['value']

                comment = False
                try:
                    if _v['comment'] is True:
                        comment = True
                except:
                    pass

                if type(val) == list:
                    for _val in val:
                        aline = "%s%s%s" % (_k,self._new_delim,_val,)
                        if comment is True:
                            aline = "%s%s" % (self._comment,aline,)
                        lines.append(aline)
                else:
                    aline = "%s%s%s" % (_k,self._new_delim,val,)
                    lines.append(aline)

            except:
                pass

        return lines

    def write_conf(self,conf_arr={},dryrun=False):
        retval = True

        self.dop.addconf(self._module,conf_arr)

        tmp_conf_arr = copy.deepcopy(conf_arr)
        for _path, _dop_v in tmp_conf_arr.iteritems():
            lines = []

            if _path[0:1] != "/":
                continue
            if _dop_v.has_key('value') is False:
                continue

            # - Section part
            exclude_regex = "^%s[A-Z0-9\_]+$" % self._reserved_key_prefix

            if self.dop.isset(self._module,[_path]) is True:
                for _section in self.dop.get(self._module,[_path]):
                    m = re.match(exclude_regex, _section)
                    if m: # Exclude item
                        continue

                    try:
                        lines = lines + [self._start_section + _section + self._end_section]
                    except:
                        pass

                    # - Key and value part
                    if self.dop.isset(self._module,[_path, _section]) is True:
                        for _key in self.dop.get(self._module,[_path, _section]):
                            m = re.match(exclude_regex, _key)
                            if m: # Exclude item
                                continue
                            try:
                                key_value = {}
                                key_value[_key] = _dop_v['value'][_section]['value'][_key]
                                lines = lines + self._value_to_lines(key_value)
                            except:
                                pass

            if dryrun is False:
                if len(lines) > 0:
                    iniConfigFile(_path).write("\n".join(lines) + "\n")
                if len(lines) == 0:
                    iniConfigFile(_path).write("")
            else:
                print "--- %s ---" % _path
                if len(lines) > 0:
                    print "\n".join(lines)
                if len(lines) == 0:
                    print ""

        return retval

"""
"""
if __name__ == '__main__':
    """Testing
    """
    pass
