#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

import os
import re
import sys
import glob
import copy

from karesansui.lib.dict_op import DictOp
from karesansui.lib.parser.base.ini_conf_parser import iniConfParser as Parser
from karesansui.lib.utils import preprint_r
from karesansui.lib.const import TRANSARC_DEFAULT_CONFIG_PATH


"""
Define Variables for This Parser
"""

class transarcParser:

    _module = "transarc"

    def __init__(self, paths=None):
        self.dop = DictOp()
        self.dop.addconf(self._module,{})

        self.parser = Parser()
        self.base_parser_name = self.parser.__class__.__name__

        if paths is None:
            self.paths = TRANSARC_DEFAULT_CONFIG_PATH
        else:
            self.paths = paths

    def source_file(self):
        return [self.paths]

    def read_conf(self,extra_args=None):
        retval = {}

        paths = self.paths

        self.parser.set_source_file([paths])
        conf_arr = self.parser.read_conf()
        self.dop.addconf(self._module, conf_arr[paths]['value'])
        for section_name in conf_arr[paths]['value'].keys():
            self.dop.set(self._module, [section_name, "@FILENAME"], paths)

        include = self.dop.get(self._module, ["global", "include"])

        if include is not False:
            all_conf = copy.deepcopy(self.dop.getconf(self._module))
            for filename in glob.glob(include):
                global_conf = copy.deepcopy(self.dop.get(self._module, ["global"]))

                sub_dop = DictOp()
                sub_parser = Parser()
                sub_parser.set_source_file([filename])
                sub_conf_arr = sub_parser.read_conf()
                sub_dop.addconf('real_sub_parser', sub_conf_arr[filename]['value'])
                real_sub_conf = sub_dop.getconf('real_sub_parser')

                sub_dop.addconf('sub_parser', {})
                for real_sub_section_name in real_sub_conf.keys():
                    sub_dop.set('sub_parser', [real_sub_section_name], global_conf)
                    sub_dop.set('sub_parser', [real_sub_section_name, "@FILENAME"], filename)

                    real_sub_key_list = sub_dop.query('real_sub_parser', [real_sub_section_name])
                    if type(real_sub_key_list) is False:
                        real_sub_key_list = []
                    for real_sub_key in real_sub_key_list:
                        real_sub_value = sub_dop.get('real_sub_parser', [real_sub_section_name, real_sub_key])
                        sub_dop.set('sub_parser', [real_sub_section_name, real_sub_key], real_sub_value)
                    sub_dop.delete('sub_parser', [real_sub_section_name, 'include'])
                sub_conf = sub_dop.getconf('sub_parser')

                all_conf.update(sub_conf)
            self.dop.addconf(self._module, all_conf)

        self.dop.set(self._module,['@BASE_PARSER'],self.base_parser_name)
        return self.dop.getconf(self._module)

    def write_conf(self,conf_arr={},extra_args=None,dryrun=False):
        retval = True

        exclude_regex = "^@[A-Z0-9\_]+$"
        tmp_conf_arr = copy.deepcopy(conf_arr)
        w_data = {}
        for _section, _dop_v in tmp_conf_arr.iteritems():
            m = re.match(exclude_regex, _section)
            if m: # Exclude item
                continue
            filename = _dop_v['value']['@FILENAME']['value']
            if w_data.has_key(filename) is False:
                w_data[filename] = {}
            w_data[filename][_section] = _dop_v

        self.dop.addconf("parser", {})
        for filename, data in w_data.iteritems():
            self.dop.set("parser", [filename], data)
        arr = self.dop.getconf("parser")
        self.parser.write_conf(arr, dryrun=dryrun)

        return retval

"""
"""
if __name__ == '__main__':
    """Testing
    """
    parser = transarcParser()

    dop = DictOp()
    dop.addconf("transarc",parser.read_conf())
    dop.set("transarc", ["0001", "trans.rotate"], 10)
    conf = dop.getconf("transarc")
    parser.write_conf(conf, dryrun=True)
