#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2010 HDE, Inc.
#

from karesansui.lib.service.config import ServiceConfigParam
from karesansui.lib.const import SERVICE_XML_FILE
from karesansui.lib.service.sysvinit_rh import SysVInit_RH

"""<description>
<comment-ja>
指定したサービスが起動しているか調べる
</comment-ja>
<comment-en>
Check service is running.
</comment-en>

@file:  utils.py
@author: 
@copyright:
@return: running: True, stop: False, service not found: None
"""
def is_service_running(system_name):
    # bap
    config = ServiceConfigParam(SERVICE_XML_FILE)
    config.load_xml_config()
    service = config.findby1service(system_name)
    if service:
        sysv = SysVInit_RH(service['system_name'], service['system_command'])
        if sysv.status():
            return True
        else:
            return False
    return None

if __name__ == '__main__':
    print(is_service_running('iscsid'))
    print(is_service_running('hde-collectd'))
    print(is_service_running('no_exist_service'))
