#!/bin/sh

# インストールの準備を行い、インストールを手動で行った後、
# 再度実行することで開発環境を構築するスクリプト
# - clone でwork_dir以下に取り寄せ
# - work_dir配下に取り寄せたソースをdevブランチに切替
# - RPMでインストールされた既存ディレクトリをリネーム
# - work_dirからシンボリックリンクを張る

export PATH=${PATH}:/sbin:/usr/sbin

########################################################
# This variable allows you to customize as you like..
########################################################

rpm -q kvm-qemu-img >/dev/null 2>&1 && rpm -e kvm-qemu-img --nodeps
yum -y install gnutls-utils PyXML perl-HTML-Parser perl-URI

rpm -q karesansui >/dev/null 2>&1
if [ $? -eq 1 ]; then
   echo "Please install Karesansui"
   exit 1
fi


repos_host=git.sourceforge.jp
repos_dir=/gitroot/karesansui/karesansui.git
work_dir=${HOME}

printf "%-55s:" "Working Directory[default:${work_dir}]"
read n_work_dir
if [ "x${n_work_dir}" != "x" ]; then
  work_dir="${n_work_dir}"  
fi

echo ""
echo -n "Proceed to build development environment, then press enter."
read

# Do not change unless necesary.
proxy_host="" # proxy server for http
ntp_host=ntp.nict.jp                       # ntp server
repos_uri=git://${repos_host}${repos_dir}
arch="`uname -p`"

if [ "${arch}" = "x86_64" ]; then
  pkgs_dir=pkgs.x86_64
else
  pkgs_dir=pkgs
fi

export http_proxy=${proxy_host}
export HTTP_PROXY=${proxy_host}

# Red Hat Enterprise Linux
rpm -qa | grep redhat-release >/dev/null 2>&1
if [ $? -eq 0 ]; then
  echo ""
  echo ""

  echo "rhnreg_ks --proxy=${proxy_host} --username=username --password=secret --force --profilename=`hostname` --verbose"
  echo 'sed -e "s#^sslCACert=.*#sslCACert=/usr/share/rhn/custom.crt#" /etc/sysconfig/rhn/up2date > /etc/sysconfig/rhn/up2date.new'
  echo 'vi /usr/share/rhn/custom.crt'

  echo ""
  echo ""
fi


which wget >/dev/null 2>&1
if [ $? -ne 0 ]; then
  yum -y install wget
fi

which lftpget >/dev/null 2>&1
if [ $? -ne 0 ]; then
  yum -y install lftp
fi

which git >/dev/null 2>&1
if [ $? -ne 0 ]; then
  yum -y --enablerepo=karesansui-devel install git  
fi

rpm -q kvm >/dev/null 2>&1 || yum -y groupinstall KVM

which git >/dev/null 2>&1
if [ $? -eq 0 ]; then
  echo ""
else
  echo "Error: git is not installed." >&2
  exit 1
fi

which ntpdate >/dev/null 2>&1
if [ $? -ne 0 ]; then
  yum -y install ntp
fi
/etc/init.d/ntpd stop
ntpdate ${ntp_host}
/etc/init.d/ntpd start


echo ""
echo -n "Proceed to build development environment, then press enter."
read

kss_prefix=/opt/karesansui
kss_bindir=${kss_prefix}/bin
kss_source_dir=${kss_prefix}/lib/python/karesansui

if [ ! -e ${kss_source_dir} ]; then
  echo "Warning: you should install karesansui." >&2
  exit 1
fi

if [ ! -e ${work_dir} ]; then
  mkdir -p ${work_dir}
fi
chmod go+rx ${work_dir}




pushd ${work_dir}
if [ -e karesansui.git -o -e karesansui ]; then
  echo "Warning: ${work_dir}/karesansui.git exists." >&2
  exit 1
fi
git clone ${repos_uri}

if [ -e karesansui ]; then
  mv karesansui karesansui.git
  pushd karesansui.git
  git checkout -b dev origin/dev
  popd
  if [ ! -e ${kss_bindir}.rpm ]; then
    mv ${kss_bindir} ${kss_bindir}.rpm
    ln -s ${work_dir}/karesansui.git/bin ${kss_bindir}
    cp ${work_dir}/karesansui.git/scripts/karesansui.fcgi ${kss_bindir}
    chgrp -R kss ${work_dir}/karesansui.git/bin
    chgrp -R kss ${kss_bindir}
    chmod -R g+rw ${kss_bindir}
    chmod -R o-rwx ${kss_bindir}
  fi
  if [ ! -e ${kss_source_dir}.rpm ]; then
    mv ${kss_source_dir} ${kss_source_dir}.rpm
    ln -s ${work_dir}/karesansui.git/karesansui ${kss_source_dir}
    chgrp -R kss ${work_dir}/karesansui.git/karesansui
    chgrp -R kss ${kss_source_dir}
    chmod -R g+rw ${kss_source_dir}
    chmod -R o-rwx ${kss_source_dir}
  fi
fi

echo '# su -s /bin/bash wwwhde -c "KARESANSUI_CONF=/etc/opt/karesansui/application.conf SEARCH_PATH=/opt/karesansui/lib/python:/opt/hde/lib/python:/opt/pysilhouette/lib/python /opt/karesansui/bin/karesansui.fcgi"'
