#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import sys
import logging
from optparse import OptionParser

from ksscommand import KssCommand, KssCommandException, KssCommandOptException

import __cmd__

try:
    import karesansui
    from karesansui import __version__
    from karesansui.lib.parser.iptables import iptablesParser as Parser
    from karesansui.lib.utils import load_locale
except ImportError:
    print >>sys.stderr, "[Error] karesansui package was not found."
    sys.exit(1)

_ = load_locale()

usage = '%prog [options]'

def getopts():
    optp = OptionParser(usage=usage, version=__version__)
    optp.add_option('-a', '--action', dest='action', help=_('Action'), default=None)
    optp.add_option('-t', '--lint', dest='lint', help=_('Lint'), default=None)
    return optp.parse_args()

def chkopts(opts):
    pass

class ControlIptables(KssCommand):

    def process(self):
        (opts, args) = getopts()
        chkopts(opts)
        self.up_progress(10)

        parser = Parser()

        self.up_progress(10)
        if opts.lint is not None:
            if os.path.exists(opts.lint):
                (ret, stdout, stderr) = parser.do_lint(open(opts.lint).read())
                if ret != 0:
                    print stderr
            else:
                error_msg = "ERROR: file not found '%s'." % (opts.lint)
                self.logger.error(error_msg)
                raise KssCommandOptException(error_msg)

        elif opts.action is not None:
            try:
                #import pdb; pdb.set_trace()
                exec("func = parser.do_%s" % opts.action)
                self.up_progress(10)
                (ret,res) = func()
                if ret is False:
                    error_msg = "ERROR: failed to %s" % (opts.action)
                    self.logger.error(error_msg)
                    raise KssCommandOptException(error_msg)
                self.up_progress(30)
            except KssCommandOptException, e:
                raise KssCommandOptException(''.join(e.args))
            except:
                error_msg = "ERROR: unknown action '%s'." % (opts.action)
                self.logger.error(error_msg)
                raise KssCommandOptException(error_msg)

        return True

if __name__ == "__main__":
    target = ControlIptables()
    sys.exit(target.run())
