#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import os.path
import sys
import signal
import logging
from optparse import OptionParser

from ksscommand import KssCommand, KssCommandException, KssCommandOptException

import __cmd__

try:
    import karesansui
    from karesansui import __version__
    from karesansui.lib.virt.virt import KaresansuiVirtConnection, KaresansuiVirtException
    from karesansui.lib.utils import load_locale
    from karesansui.lib.const import VIRT_DOMAINS_DIR
except ImportError:
    print >>sys.stderr, "[Error] karesansui package was not found."
    sys.exit(1)

_ = load_locale()

usage = '%prog [options]'

def getopts():
    optp = OptionParser(usage=usage, version=__version__)
    optp.add_option('-n', '--name', dest='name', help=_('Domain name'))
    optp.add_option('-p', '--pool', dest='pool', help=_('Storage pool name'))
    optp.add_option('-d', '--dir',  dest='dir',  help=_('Directory name'))
    optp.add_option('-t', '--title',dest='title',default='', help=_('Export title'))
    optp.add_option('-q', '--quiet',dest='verbose', action="store_false", default=True, help=_("don't print status messages"))

    return optp.parse_args()

def chkopts(opts):
    if not opts.name:
        raise KssCommandOptException('ERROR: -n or --name option is required.')
    if not opts.pool and not opts.dir:
        raise KssCommandOptException('ERROR: -p/--pool or -d/--dir options are required.')

class ExportGuest(KssCommand):

    def __grab_stdout(self, flag):
        if flag:
                self.stdout = sys.stdout
                sys.stdout = os.fdopen(sys.stdout.fileno(), "w", 0)
                logf = open("/dev/null", "a")
                os.dup2(logf.fileno(), 1)
                logf.close()
        else:
                os.dup2(sys.stdout.fileno(), 1)
                sys.stdout = self.stdout
                del self.stdout

    def process(self):
        (opts, args) = getopts()
        chkopts(opts)
        self.up_progress(1)

        self.domain_dir  = "%s/%s" % (VIRT_DOMAINS_DIR,opts.name,)

        if os.path.isdir(self.domain_dir) is False:
            raise KssCommandException(
                'domain directory is not found or not directory. - %s' % (self.domain_dir))

        extra = None
        try:
            from karesansui.db.access.machine import findby1name
            extra = findby1name(self.kss_session, opts.name)
            tags = []
            try:
                for _tag in extra.tags:
                    #tags.append(_tag.name.encode("utf-8"))
                    tags.append(_tag.name)
            except:
                pass
            extra.tags_str = ",".join(tags)
            try:
                #extra.notebook.title = extra.notebook.title.encode("utf-8")
                #extra.notebook.value = extra.notebook.value.encode("utf-8")
                pass
            except:
                pass
        except:
            pass

        from karesansui.lib.utils import preprint_r, base64_decode
        conn = KaresansuiVirtConnection(readonly=False)
        try:
            try:
                target_dir = ""
                if opts.pool:
                    pool = conn.search_kvn_storage_pools(opts.pool)
                    storage_info = pool[0].get_info()
                    if storage_info["type"] == "dir" and storage_info["target"]["path"] != "":
                        target_dir = storage_info["target"]["path"]
                elif opts.dir:
                    target_dir = opts.dir


                self.up_progress(1)

                progresscb = None
                if opts.verbose:
                    try:
                        from karesansui.lib.progress import ProgressMeter
                        progresscb = ProgressMeter(command_object=self)
                    except:
                        pass
                else:
                    try:
                        from karesansui.lib.progress import ProgressMeter
                        progresscb = ProgressMeter(command_object=self,quiet=True)
                    except:
                        pass

                if opts.title[0:4] == "b64:":
                    title = base64_decode(opts.title[4:])
                else:
                    title = opts.title
                conn.export_guest(opts.name, target_dir, title=title, extra=extra, progresscb=progresscb)

                self.up_progress(40)

            except KaresansuiVirtException, e:
                self.logger.error('Failed to export guest. - %s to %s [%s]' % (opts.name,target_dir, ''.join(e.args)))
                raise
            except:
                self.logger.error('Failed to export guest. - %s to %s' % (opts.name,target_dir))
                raise
        finally:
            conn.close()

        return True

if __name__ == "__main__":
    target = ExportGuest()
    sys.exit(target.run())
