# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import sys
import re
import time
import web

from karesansui.lib.rest import Rest, auth

from karesansui.db.access.machine import findbyhost1
from karesansui.lib.utils import get_ifconfig_info, dict_ksort
from karesansui.lib.conf import read_conf, write_conf

class HostBy1NetworkSettingsGeneral(Rest):

    @auth
    def _GET(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        #import pdb; pdb.set_trace()
        self.view.host_id = host_id
        self.view.current = get_ifconfig_info()

        modules = ["network","resolv","hosts"]

        host = findbyhost1(self.orm, host_id)
        dop = read_conf(modules, self, host)
        if dop is False:
            return web.internalerror('Internal Server Error. (Timeout)')

        self.view.gateway    = dop.get("network",["GATEWAY"])
        self.view.search     = dop.get("resolv" ,["search"])

        self.view.nameserver = dop.get("resolv" ,["nameserver"])
        if self.view.nameserver is False:
            self.view.nameserver = []
        if type(self.view.nameserver) == str:
            self.view.nameserver = [self.view.nameserver]
        self.view.nameserver = "\n".join(self.view.nameserver)

        self.view.domainname  = dop.get("resolv" ,["domain"])
        if self.view.domainname is False:
            self.view.domainname = dop.get("network" ,["DOMAINNAME"])
        if self.view.domainname is False:
            self.view.domainname = re.sub("^[^\.]+\.","",os.uname()[1])

        self.view.hostname = dop.get("network" ,["HOSTNAME"])
        if self.view.hostname is False:
            self.view.hostname = os.uname()[1]

        self.view.hostname_short = re.sub("\.%s$" % (self.view.domainname), "", self.view.hostname)

        # --
        return True

    @auth
    def _PUT(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        #import pdb;pdb.set_trace()
        modules = ["network","resolv","hosts"]

        host = findbyhost1(self.orm, host_id)
        dop = read_conf(modules, self, host)
        if dop is False:
            return web.internalerror('Internal Server Error. (Timeout)')

        gateway  = self.input.gateway
        hostname = self.input.fqdn
        nameservers = self.input.nameserver.strip().split()

        domainname     = re.sub("^[^\.]+\.","",hostname)
        hostname_short = re.sub("\.%s$" % (domainname), "", hostname)


        old_domainname  = dop.get("resolv" ,["domain"])
        if old_domainname is False:
            old_domainname = dop.get("network" ,["DOMAINNAME"])
        if old_domainname is False:
            old_domainname = re.sub("^[^\.]+\.","",os.uname()[1])

        old_hostname = dop.get("network" ,["HOSTNAME"])
        if old_hostname is False:
            old_hostname = os.uname()[1]

        old_hostname_short = re.sub("\.%s$" % (old_domainname), "", old_hostname)

        # hosts
        hosts_arr = dop.getconf("hosts")
        for _k,_v in hosts_arr.iteritems():
            _host = dop.get("hosts",[_k])
            _value   = _host[0]
            _comment = _host[1]
            _values  = _value.strip().split()
            new_values = []
            for _entry in _values:
                if _entry == old_hostname:
                    _entry = hostname
                elif _entry == old_hostname_short:
                    _entry = hostname_short
                new_values.append(_entry)
            new_value = " ".join(new_values)
            dop.set("hosts" ,[_k] ,[new_value,_comment])

        dop.set("network" ,["GATEWAY"]    ,gateway)
        dop.set("resolv"  ,["nameserver"] ,nameservers)
        dop.set("resolv"  ,["domain"]     ,domainname)
        dop.set("network" ,["DOMAINNAME"] ,domainname)
        dop.set("network" ,["HOSTNAME"]   ,hostname)

        retval = write_conf(dop, self, host)
        if retval is False:
            return web.internalerror('Internal Server Error. (Adding Task)')

        return web.accepted(url=web.ctx.path)


urls = (
    '/host/(\d+)/networksettings/general/?(\.part)?$', HostBy1NetworkSettingsGeneral,
    )
