# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import web
from web.utils import Storage

import karesansui
from karesansui.lib.rest import Rest, auth
from karesansui.lib.virt.virt import KaresansuiVirtConnection
from karesansui.lib.const import VIRT_COMMAND_START_STORAGE_POOL,VIRT_COMMAND_DESTROY_STORAGE_POOL

from karesansui.db.access.machine import findbyhost1
from karesansui.db.access._2pysilhouette import save_job_collaboration
from karesansui.db.access.machine2jobgroup import new as m2j_new
from karesansui.db.model._2pysilhouette import JobGroup, Job

from pysilhouette.command import dict2command

# storage pool status
STORAGE_POOL_START = 0;
STORAGE_POOL_STOP = 1;

class HostBy1StoragePoolBy1Status(Rest):

    @auth
    def _GET(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        self.view.host_id = host_id
        
        # Pool
        try:
            kvc = KaresansuiVirtConnection()
            inactive_pool = kvc.list_inactive_storage_pool()
            active_pool = kvc.list_active_storage_pool()
            pools = inactive_pool + active_pool
            pools.sort()
            
            self.view.pools = pools
            
            pools_obj = kvc.get_storage_pool_UUIDString2kvn_storage_pool(param[1])
            if len(pools_obj) <= 0:
                return web.notfound()

            status = STORAGE_POOL_STOP
            if pools_obj[0].is_active() is True:
                status = STORAGE_POOL_START

            if self.__template__["media"] == 'json':
                self.view.status = json_dumps(status)
            else:
                self.view.status = status

            return True
        finally:
            kvc.close()

    @auth
    def _PUT(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        self.view.host_id = host_id

        model = findbyhost1(self.orm, host_id)

        # Pool
        try:
            kvc = KaresansuiVirtConnection()
            inactive_pool = kvc.list_inactive_storage_pool()
            active_pool = kvc.list_active_storage_pool()
            pools = inactive_pool + active_pool
            pools.sort()
            
            self.view.pools = pools
            
            pools_obj = kvc.get_storage_pool_UUIDString2kvn_storage_pool(param[1])
            if len(pools_obj) <= 0:
                return web.notfound()

            status = int(self.input.status)
            if status == STORAGE_POOL_START:
                storagepool_start_stop_job(self, model, pools_obj[0].get_storage_name(), 'start')
            elif status == STORAGE_POOL_STOP:
                storagepool_start_stop_job(self, model, pools_obj[0].get_storage_name(), 'stop')
            else:
                return web.badrequest()

            return web.accepted()
        finally:
            kvc.close()

def storagepool_start_stop_job(obj, host, name, status):

    if status == 'start':
        _cmd = dict2command(
            "%s/%s" % (karesansui.config['application.bin.dir'], VIRT_COMMAND_START_STORAGE_POOL),
            {"name" : name})
        cmdname = "Start Storage Pool"
    else:
        _cmd = dict2command(
            "%s/%s" % (karesansui.config['application.bin.dir'], VIRT_COMMAND_DESTROY_STORAGE_POOL),
            {"name" : name})
        cmdname = "Stop Storage Pool"

    _jobgroup = JobGroup(cmdname, karesansui.sheconf['env.uniqkey'])
    _job = Job('%s command' % cmdname, 0, _cmd)
    _jobgroup.jobs.append(_job)
    
    _machine2jobgroup = m2j_new(machine=host,
                                jobgroup_id=-1,
                                uniq_key=karesansui.sheconf['env.uniqkey'],
                                created_user=obj.me,
                                modified_user=obj.me,
                                )
    
    save_job_collaboration(obj.orm,
                           obj.pysilhouette.orm,
                           _machine2jobgroup,
                           _jobgroup,
                           )
    
urls = (
    '/host/(\d+)/storagepool/([a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12})/status/?(\.part)$', HostBy1StoragePoolBy1Status,
    )
