#/usr/bin/env python
# -*- coding: utf-8 -*-

import time
import os

from bsddb import hashopen, btopen
from karesansui.lib.const import COUNTUP_DATABASE_PATH, KARESANSUI_GROUP

"""
Berkeley DBにキーの値（カウント情報）を書き込む

キー：カテゴリー名(半角文字)
値  ：カテゴリーのカウント数、最終更新時刻(Unixtime)、初期データ投入時刻(Unixtime) のリスト配列をstrでキャストした文字列

Example:

>>> from karesansui.lib.countup import CountUp
>>> countup = CountUp()
>>> countup.up("memory_used_exceeded")
True
>>> print countup.get("memory_used_exceeded")
[1, 1270711260.0310149, 1270711260.0310149]
>>> countup.up("memory_used_exceeded")
True
>>> print countup.get("memory_used_exceeded")
[2, 1270711279.296293, 1270711260.0310149]
>>> print countup.get_count("memory_used_exceeded")
2
>>> print countup.get_mtime("memory_used_exceeded")
1270711279.3
>>> print countup.get_since("memory_used_exceeded")
1270711260.03
>>> countup.init("memory_used_exceeded")
True
>>> print countup.get("memory_used_exceeded")
[0, 1270711312.025028, 1270711312.025028]
>>> countup.finish()
>>> 

"""

class CountUp:

    path = None

    def __init__(self, path=None):
        if path is None:
            self.path = COUNTUP_DATABASE_PATH
        else:
            self.path = path

        self._set_db_type("bt")     # B-Tree
        self._set_db_type("hash")   # Hash

        try:
            self.create()
        except:
            raise

    def _set_db_type(self,type="hash"):
        self.db_type = type

    def _open(self, flag="c", mode=0000):
        func = "%sopen" % self.db_type
        try:
            exec("ret = %s(self.path, flag, mode)" % func)
            return ret
        except:
            raise

    def _close(self):
        try:
            self.db.close()
        except:
            pass

    def create(self):
        if not os.path.exists(self.path):
            self.db = self._open("c")
            from karesansui.lib.utils import r_chmod, r_chgrp
            r_chgrp(self.path,KARESANSUI_GROUP)
            r_chmod(self.path,"g+rw")
        else:
            self.db = self._open("c")
        pass

    def destroy(self):
        self._close()
        if os.path.exists(self.path):
            os.unlink(self.path)

    def finish(self):
        self._close()

    def get(self,key):
        retval = []
        if self.db.has_key(key) == 1:
            exec("retval = %s" % self.db[key])
        return retval

    def get_count(self,key):
        count = 0
        if self.db.has_key(key) == 1:
            (count,mtime,since) = self.get(key)
        return count

    def get_mtime(self,key):
        mtime = 0
        if self.db.has_key(key) == 1:
            (count,mtime,since) = self.get(key)
        return mtime

    def get_since(self,key):
        since = 0
        if self.db.has_key(key) == 1:
            (count,mtime,since) = self.get(key)
        return since

    def up(self,key):
        retval = False

        now = time.time()
        if self.db.has_key(key) == 1:
            (count,old,since) = self.get(key)
            count =  count + 1
        else:
            count = 1
            since = now
        value = [count,now,since]

        try:
            self.db[key] = str(value)
            retval = True
        except:
            pass

        return retval

    def init(self,key):
        retval = False

        count = 0
        now = time.time()
        since = now
        value = [count,now,since]

        try:
            self.db[key] = str(value)
            retval = True
        except:
            pass

        return retval


if __name__ == '__main__':

  countup = CountUp()
  countup.init("memory_used_exceeded")
  countup.up("memory_used_exceeded")
  countup.up("memory_used_exceeded")
  countup.up("memory_used_exceeded")
  print countup.get("memory_used_exceeded")
  print countup.get_count("memory_used_exceeded")
  print countup.get_mtime("memory_used_exceeded")
  print countup.get_since("memory_used_exceeded")
  countup.finish()

