// This file is part of Karesansui Core.
//
// Copyright (C) 2009-2010 HDE, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// Authors:
//     Kei Funagayama <kei@karesansui-project.info>
//

function grayout_view(type, url, title, reflush, async_flag){

    async_flag = set_async_flag(async_flag);

    if($("div[class*='ui-dialog']").size() != 0){
        $("div[class*='ui-dialog']").remove();
    }

    $('#screen').append('<div id="dialog_screen"></div>');

/*
 * TODO: Display loading image to center of dialog
 */
    $('#dialog_screen').append('<div id="dialog_loading" align="center"><div style="padding-top:150px;">&nbsp;</div><img src="${ctx.homepath}/static/images/now-loading.gif" alt="Now Loading" /></div>');

    timer = setTimeout(function(){
        $('#dialog_screen').dialog({
            width: 800,
            height:520,
            modal: true,
            resizable: false,
            title: title,
            buttons:{
                'close':function() {$(this).dialog('close');}
            },
            beforeclose: function() {
                renew_all(false);
                $("#cluetip").hide();
            },
            open: function() {
                $("div[class*='ui-dialog-buttonpane'] > button").hide();
                $.ajax({
                    type: type,
                    url: url,
                    async: async_flag,
                    success: function(data) {
                        $('#dialog_screen').append('<div class="grayout-alert">');
                        $('#dialog_screen').append(data);
                        $('#dialog_loading').hide();
                        $("div[class*='ui-dialog-buttonpane']").prepend($("div.grayout-footer"));
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $('#dialog_screen').dialog('close');
                    }
                });
            }
        });
    }, 500);

    g_main_url = reflush;
    return timer;
}

function delete_dialog(id, url, param, reflush, button){
    if($("div[class*='ui-dialog']").size() != 0){
        $("div[class*='ui-dialog']").remove();
        $('#screen').append('<div id="' + id.slice(1) + '"></div>');
    }

    $(id).text("${_('Do you really want to remove the target?')}");

    var _click_flag = false;

    $(id).dialog({
        width: 400,
        modal: true,
        resizable: false,
        title: "${_('Confirm')}",
        close: function(event, ui){
            if(_click_flag == false){
                _click_flag = true;
                $(".ui-dialog-buttonpane button").attr("disabled","disabled");
                if(button){
                    tool_reset(button);
                }
                $(this).dialog("close");
            }
        },
        buttons:{
            ${_("Cancel")} : function() {
                if(_click_flag == false){
                    _click_flag = true;
                    $(".ui-dialog-buttonpane button").attr("disabled", "disabled");
                    if(button){
                        tool_reset(button);
                    }
                    $(this).dialog("close");
                }
            },
            ${_("Delete")} : function(){
                if(_click_flag == false){
                    _click_flag = true;
                    $(".ui-dialog-buttonpane button").attr("disabled", "disabled");
                    $.remove(url,
                        param,
                        function(data, status){
                            if (status == "success") {
                                g_main_url = reflush;
                                renew_all(false);
                                alert_on(".alert", "SUCCEED", "${_('Was removed.')}");
                            }
                        }
                    );
                    $(this).dialog("close");
                }
            }
        }
    });
}
function apply_dialog(id, url, param, reflush, button){
    if($("div[class*='ui-dialog']").size() != 0){
        $("div[class*='ui-dialog']").remove();
        $('#screen').append('<div id="' + id.slice(1) + '"></div>');
    }

    $(id).text("${_('OK to apply changes?')}");

    var _click_flag = false;

    $(id).dialog({
        width: 400,
        modal: true,
        resizable: false,
        title: "${_('Confirm')}",
        close: function(event, ui){
            if(_click_flag == false){
                _click_flag = true;
                $(".ui-dialog-buttonpane button").attr("disabled", "disabled");
                if(button){
                    tool_reset(button);
                }
                $(this).dialog("close");
            }
        },
        buttons:{
            ${_("Cancel")}:function() {
                if(_click_flag == false){
                    _click_flag = true;
                    $(".ui-dialog-buttonpane button").attr("disabled", "disabled");
                    if(button); tool_reset(button);
                    $(this).dialog("close");
                }
            },
            ${_("Apply")}:function(){
                if(_click_flag == false){
                    _click_flag = true;
                    $(".ui-dialog-buttonpane button").attr("disabled", "disabled");
                    $.put(url,
                        param,
                        function(data, status){
                            if (status == "success") {
                                g_main_url = reflush;
                                renew_all(false);
                                alert_on(".alert", "SUCCEED", "${_('Was applied.')}");
                            }
                        }
                    );
                    $(this).dialog("close");
                }
            }
        }
    });
}
