// This file is part of Karesansui Core.
//
// Copyright (C) 2009-2010 HDE, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// Authors:
//     Kei Funagayama <kei@karesansui-project.info>
//

function make_tr(name, value, is_plane){
    var name_tag = "<th>" + name + "</th>";
    var image_tag = "<td class='detail-separator'><img src='${ctx.homepath}/static/images/table-space.gif' alt='' /></td>";
    if(typeof(is_plane) == "undefined"){
        is_plane = false;
    } 

    if(is_plane == true){
        var value_tag = "<td>" + value + "</td>";
    } else {
        var value_tag = "<td><pre>" + jQuery("<span>" + value + "</span>").text() + "</pre></td>";
    }

    return "<tr>" + name_tag + image_tag + value_tag + "</tr>";
}

function make_status_bar(name, total, free){
    var used = Math.round(total - free);
    var used_percent = Math.round(100 - ((free / total) * 100));
    var _status;

    total = Math.round(total);
    free = Math.round(free);

    _status_bar = '<table cellspacing="2" cellpadding="0" class="detail-sub-contents detail-status-contents" >'
                    + '<td><span class="status-bar-active" title="'
                    + '${_("Used")}: '
                    + used + 'MB"><em title="'
                    + '${_("Free")}: '
                    + free + 'MB" class="status-bar-back" style="left: '
                    + used_percent + '%;">'
                    + used_percent + '%</em></span></td><td>'
                    + used + ' / '
                    + total + ' MB</td></table>';
    return make_tr(name, _status_bar, true);
}

function make_space(){
    return "<tr><td colspan='3'><div class='detail-space'/></td></tr>";
}

function format_cputime(num){
    num = num.toString();
    var int_part = num.split(".")[0];
    var dec_part = num.split(".")[1];

    var ret = "";
    if(dec_part == undefined){
        ret = int_part + ".00";
    } else {
        ret = int_part + "." + dec_part.slice(0, 2);
    }

    return ret;
}

function show_detail_event(){
    $("#show_detail_switch").click(function(){
        if($("#detail_value").html() != "--"){
            var src_val = "${ctx.homepath}/static/images/tree-close.gif";
            
            $("#detail_value").toggle(500);
            if($(this).attr("src").indexOf("tree-open.gif") == -1){
                src_val = "${ctx.homepath}/static/images/tree-open.gif";
            }
            $(this).attr("src", src_val);
        }
    });
}

function join_comma(value){
    var ret = "";

    for(var i = 0; i < value.length; i++){
        ret += value[i] + ", ";
    }

    ret = ret.slice(0, ret.length - 2);

    return ret;
}

function str_status(status){
    if(status == VIR_DOMAIN_NOSTATE){
        return 'NOSTATE';
    } else if(status == VIR_DOMAIN_CRASHED){
        return 'CRASHED';
    } else if(status == VIR_DOMAIN_SHUTOFF){
        return 'SHUTOFF';
    } else if(status == VIR_DOMAIN_SHUTDOWN){
        return 'SHUTDOWN';
    } else if(status == VIR_DOMAIN_PAUSED){
        return 'PAUSED';
    } else if(status == VIR_DOMAIN_BLOCKED){
        return 'BLOCKED';
    } else if(status == VIR_DOMAIN_RUNNING){
        return 'RUNNING';
    } else{
        return null;
    }
}
