#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import sys
import logging
from optparse import OptionParser

from ksscommand import KssCommand, KssCommandException, KssCommandOptException

import __cmd__

try:
    import karesansui
    from karesansui import __version__
    from karesansui.lib.virt.virt import KaresansuiVirtConnection
    from karesansui.lib.utils import load_locale
    from karesansui.lib.const import STORAGE_POOL_TYPE
except ImportError:
    print >>sys.stderr, "[Error] karesansui package was not found."
    sys.exit(1)

_ = load_locale()

usage = '%prog [options]'

def getopts():
    optp = OptionParser(usage=usage, version=__version__)
    optp.add_option('-n', '--name', dest='name', help=_('Name'))
    optp.add_option('-t', '--type', dest='type', help=_('Pool Type (dir or iscsi)'))
    optp.add_option('-p', '--target_path', dest='target_path', help=_('Target path (dir)'))
    optp.add_option('-f', '--mkdir_force', dest='mkdir_force', action="store_true", help=_('Target path to create a force (dir)'))
    #optp.add_option('-a', '--allocation', dest='allocation', help=_('Allocation'), type="int", default=0)
    #optp.add_option('-v', '--available', dest='available', help=_('Available'), type="int", default=0)
    #optp.add_option('-c', '--capacity', dest='capacity', help=_('Capacity'), type="int", default=0)
    optp.add_option('-b', '--host_name', dest='host_name', help=_('Host Name (iscsi)'))
    optp.add_option('-d', '--device_path', dest='device_path', help=_('Device Path (iscsi)'))
    optp.add_option('-g', '--group', dest='group', help=_('Permission Group'))
    optp.add_option('-l', '--label', dest='label', help=_('Permission Label'))
    optp.add_option('-m', '--mode', dest='mode', help=_('Permission mode'))
    optp.add_option('-o', '--owner', dest='owner', help=_('permission owner'))
    return optp.parse_args()

def chkopts(opts):
    if not opts.name:
        raise KssCommandOptException('ERROR: %s option is required.' % '-n or --name')

    if not opts.type:
        raise KssCommandOptException('ERROR: %s option is required.' % '-t or --type')

    if not opts.type in STORAGE_POOL_TYPE.values():
        raise KssCommandOptException('ERROR: Type is not available. '
                                     'iscsi or dir is available. type=%s' % opts.type)

    if opts.type == STORAGE_POOL_TYPE["TYPE_DIR"]:
        # type:dir
        if not opts.target_path:
            raise KssCommandOptException('ERROR: %s option is required.' % '-p or --target_path')
        if opts.mkdir_force is False and os.path.isdir(opts.target_path) is False:
            raise KssCommandOptException('ERROR: Target path Directory does not exist. target_path=%s' %
                                         opts.target_path)

    elif opts.type == STORAGE_POOL_TYPE["TYPE_ISCSI"]:
        # TODO type:iscsi
        if not opts.host_name:
            raise KssCommandOptException('ERROR: %s option is required.' % '-b or --host_name')
        if not opts.device_path:
            raise KssCommandOptException('ERROR: %s option is required.' % '-d or --device_path')
    else:
        raise KssCommandOptException('ERROR: The type that does not exist. type=%s' % opts.type)

class CreateStorage(KssCommand):

    def process(self):
        (opts, args) = getopts()
        chkopts(opts)
        self.up_progress(10)
        conn = KaresansuiVirtConnection(readonly=False)
        
        try:
            inactive_storage_pools = conn.list_inactive_storage_pool()
            active_storage_pools = conn.list_active_storage_pool()

            self.up_progress(10)

            if opts.name in active_storage_pools or opts.name in inactive_storage_pools:
                raise KssCommandException('Storage pool already exists. - pool=%s' % opts.name)

            try:
                if opts.type == STORAGE_POOL_TYPE["TYPE_DIR"]:
                    if conn.create_storage_pool(opts.name, opts.type,
                                                opts.target_path, opts.mkdir_force,
                                                #allocation=opts.allocation, available=opts.available,
                                                #capacity=opts.capacity,
                                                target_p_group=opts.group, target_p_label=opts.label,
                                                target_p_mode=opts.mode, target_p_owner=opts.owner,
                                                ) is False:
                        raise KssCommandException('Failed to create storage pools. - pool=%s' \
                                                  % opts.name)

                elif opts.type == STORAGE_POOL_TYPE["TYPE_ISCSI"]:
                    if  conn.create_storage_pool(opts.name, opts.type,
                                                 target_path="/dev/disk/by-path",
                                                 source_h_name=opts.host_name,
                                                 source_dev_path=opts.device_path,
                                                 #allocation=opts.allocation, available=opts.available,
                                                 #capacity=opts.capacity,
                                                 target_p_group=opts.group, target_p_label=opts.label,
                                                 target_p_mode=opts.mode, target_p_owner=opts.owner,
                                                 ) is False:
                        raise KssCommandException('Failed to create storage pools. - pool=%s' \
                                                  % opts.name)

                else:
                    raise KssCommandOptException('ERROR: The type that does not exist. type=%s' \
                                                 % opts.type)
                    
                self.up_progress(20)
                # pool check
                inactive_storage_pools = conn.list_inactive_storage_pool()
                active_storage_pools = conn.list_active_storage_pool()

                if not (opts.name in active_storage_pools or opts.name in inactive_storage_pools):
                    raise KssCommandException(
                        'Failed to create storage pools. (Unexplained) - pool=%s' \
                        % opts.name)
                
                self.up_progress(20)
                # pool autostart check
                flag = True # autostart on
                if conn.autostart_storage_pool(flag) is False:
                    raise KssCommandException(
                        'Failed to autostart storage pool(libvirt). - pool=%s'
                        % (opts.name))

                ret = conn.is_autostart_storage_pool()
                if not (ret is flag):
                    raise KssCommandException(
                        'Auto-start failed to set the storage pool. - pool=%s, autostart=%s' \
                        % (opts.name, str(ret)))

                self.logger.info('Created storage pool. - pool=%s' % (opts.name))
                print >>sys.stdout, _('Created storage pool. - pool=%s') % (opts.name)
                return True
            except KssCommandException, e:
                raise e
        finally:
            conn.close()

if __name__ == "__main__":
    target = CreateStorage()
    sys.exit(target.run())
