#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

from karesansui.db.model.watch import Watch
from karesansui.db.model.machine import Machine
from karesansui.db.access import dbsave, dbupdate, dbdelete
from karesansui.db.access.search import findbyand as _findbyand

# -- all
def findbyall(session, is_deleted=False):
    return session.query(Watch).filter(
        Watch.is_deleted == is_deleted).all()

def findby1(session, watch_id, is_deleted=False):
    return session.query(Watch).filter(
        Watch.id == watch_id).filter(
        Watch.is_deleted == is_deleted).first()

def findbyallmachine(session, machine, is_deleted=False):
    return session.query(Watch).filter(
        Watch.machine_id == machine.id).filter(
        Watch.is_deleted == is_deleted).all()

def findbyallplugin(session, plugin, is_deleted=False):
    return session.query(Watch).filter(
        Watch.plugin == plugin).filter(
        Watch.is_deleted == is_deleted).all()

def findby1name(session, name, is_deleted=False):
    return session.query(Watch).filter(
        Watch.name == name).filter(
        Watch.is_deleted == is_deleted).first()

def findbyand(session, query):
    return _findbyand(session, query, Watch, [Watch.name])

@dbupdate
def logical_delete(session, watch):
    watch.is_deleted = True
    return session.update(watch)

@dbsave
def save(session, watch):
    session.save(watch)

@dbupdate
def update(session, watch):
    session.update(watch)
    
# new instance
new = Watch

def test(session):
    from karesansui.db.access.user import findby1 as user_findby1
    user = user_findby1(session, 1)
    from karesansui.db.access.machine import findby1 as machine_findby1
    machine = machine_findby1(session, 1)

    plugin_selector = """<Match>
plugin hoge
</Match>"""
    import os
    watch = Watch(created_user=user,
                  modified_user=user,
                  machine=machine,
                  name='dummy_watch_%s' % str(os.getpid()),
                  plugin='cpu',
                  plugin_selector=plugin_selector,
                  karesansui_version='1.2.0',
                  collectd_version='4.9.1',
                  is_deleted=False
                  )
    import pdb; pdb.set_trace()
    
    save(session, watch)
    session.commit()
    _all = findbyall(session)
    _findby1 = findby1(session, watch.id)
    _findbyallmachine = findbyallmachine(session, watch.machine)
    _findbyallplugin = findbyallplugin(session, watch.plugin)
    _findby1name = findby1name(session, watch.name)
    import pdb; pdb.set_trace()

if __name__ == '__main__':
    test()
