# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import sys
import re
import time
import web

from karesansui.lib.rest import Rest, auth
from karesansui.db.access.machine import findbyhost1
from karesansui.lib.utils import get_ifconfig_info, dict_ksort, preprint_r
from karesansui.lib.conf import read_conf, write_conf
from karesansui.lib.networkaddress import NetworkAddress

class HostBy1NetworkSettingsNicBy1(Rest):

    @auth
    def _GET(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        self.view.host_id = host_id
        self.view.current = get_ifconfig_info()
        self.view.device = param[1]

        modules = ["ifcfg"]

        host = findbyhost1(self.orm, host_id)
        dop = read_conf(modules,self,host)
        if dop is False:
            return web.internalerror('Internal Server Error. (Timeout)')

        self.view.bootproto = dop.get("ifcfg",[self.view.device,"BOOTPROTO"])
        if self.view.bootproto is False:
            self.view.bootproto = "static"

        self.view.onboot    = dop.get("ifcfg",[self.view.device,"ONBOOT"])
        if self.view.onboot is False:
            self.view.onboot = "yes"

        self.view.ipaddr    = dop.get("ifcfg",[self.view.device,"IPADDR"])
        if self.view.ipaddr is False:
            self.view.ipaddr = _('N/A')

        self.view.netmask   = dop.get("ifcfg",[self.view.device,"NETMASK"])
        if self.view.netmask is False:
            self.view.netmask = _('N/A')

        self.view.network   = dop.get("ifcfg",[self.view.device,"NETWORK"])
        if self.view.network is False:
            net = NetworkAddress("%s/%s" % (self.view.ipaddr,self.view.netmask))
            if net.valid_addr(self.view.ipaddr) is True and net.valid_addr(self.view.netmask) is True:
                self.view.network = net.network
            else:
                self.view.network = _('N/A')

        self.view.broadcast = dop.get("ifcfg",[self.view.device,"BROADCAST"])
        if self.view.broadcast is False:
            net = NetworkAddress("%s/%s" % (self.view.ipaddr,self.view.netmask))
            if net.valid_addr(self.view.ipaddr) is True and net.valid_addr(self.view.netmask) is True:
                self.view.broadcast = net.broadcast
            else:
                self.view.broadcast = _('N/A')

        self.view.c_ipaddr    = self.view.current[self.view.device]["ipaddr"]
        if self.view.c_ipaddr is None:
            self.view.c_ipaddr = _('N/A')

        self.view.c_netmask   = self.view.current[self.view.device]["mask"]
        if self.view.c_netmask is None:
            self.view.c_netmask = _('N/A')

        if self.view.current[self.view.device]["cidr"] is None:
            self.view.c_network = _('N/A')
        else:
            self.view.c_network = re.sub("\/.*","",self.view.current[self.view.device]["cidr"])

        self.view.c_broadcast = self.view.current[self.view.device]["bcast"]
        if self.view.c_broadcast is None:
            self.view.c_broadcast = _('N/A')

        self.view.c_hwaddr = self.view.current[self.view.device]["hwaddr"]
        if self.view.c_hwaddr is None:
            self.view.c_hwaddr = _('N/A')

        # --
        return True

    @auth
    def _PUT(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        #import pdb;pdb.set_trace()

        device = param[1]

        modules = ["ifcfg"]

        host = findbyhost1(self.orm, host_id)
        dop = read_conf(modules, self, host)
        if dop is False:
            return web.internalerror('Internal Server Error. (Timeout)')

        ipaddr  = self.input.ipaddr
        netmask = self.input.netmask

        net = NetworkAddress("%s/%s" % (ipaddr,netmask))
        network   = net.network
        broadcast = net.broadcast

        dop.set("ifcfg",[device,"IPADDR"]   ,ipaddr)
        dop.set("ifcfg",[device,"NETMASK"]  ,netmask)
        dop.set("ifcfg",[device,"NETWORK"]  ,network)
        dop.set("ifcfg",[device,"BROADCAST"],broadcast)

        retval = write_conf(dop, self, host)
        if retval is False:
            return web.internalerror('Internal Server Error. (Adding Task)')


        return web.accepted(url=web.ctx.path)


urls = (
    '/host/(\d+)/networksettings/nic/([^\./]+)/?(\.part|\.json)?$', HostBy1NetworkSettingsNicBy1,
    )
