# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#


import web

from karesansui.lib.rest import Rest, auth
from karesansui.lib.pager import Pager, validates_page
from karesansui.lib.search import validates_query

from karesansui.lib.checker import Checker, \
    CHECK_EMPTY, CHECK_VALID, \
    CHECK_LENGTH, CHECK_MIN, CHECK_MAX

from karesansui.db.access.watch import \
    findbyall as w_findbyall, findby1 as w_findby1, \
    findby1name as w_findby1name, findbyand as w_findbyand, \
    new as w_new, save as w_save

from karesansui.db.access.watchdetail import \
    new as wd_new, save as wd_save

from karesansui.lib.utils import is_param, get_karesansui_version

from karesansui.lib.collectd.utils import  create_plugin_selector, \
    create_value_selector, get_collectd_version

from karesansui.lib.const import WATCH_LIST_RANGE, \
    COLLECTD_PLUGIN_CPU, COLLECTD_PLUGIN_DF, \
    COLLECTD_PLUGIN_DISK, COLLECTD_PLUGIN_INTERFACE, COLLECTD_PLUGIN_LIBVIRT, \
    COLLECTD_PLUGIN_MEMORY, COLLECTD_PLUGIN_UPTIME, COLLECTD_CPU_TYPE_INSTANCE, \
    COLLECTD_MEMORY_TYPE_INSTANCE, COLLECTD_DF_DS, COLLECTD_DISK_TYPE, \
    COLLECTD_DISK_DS, COLLECTD_INTERFACE_TYPE, COLLECTD_INTERFACE_DS, \
    COLLECTD_CPU_TYPE, COLLECTD_MEMORY_TYPE, COLLECTD_DF_TYPE, \
    COLLECTD_UPTIME_TYPE, COLLECTD_LIBVIRT_TYPE, \
    COLLECTD_CPU_DS, COLLECTD_MEMORY_DS, COLLECTD_UPTIME_DS, \
    VALUE_BOUNDS_UPPER, VALUE_BOUNDS_LOWER


def validates_watch(obj):
    check = True
    return check


class HostBy1Watch(Rest):
    @auth
    def _GET(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        if self.is_mode_input() is True:
            plugins = {
                "cpu" : COLLECTD_PLUGIN_CPU,
                "df" : COLLECTD_PLUGIN_DF,
                "disk" : COLLECTD_PLUGIN_DISK,
                "interface" : COLLECTD_PLUGIN_INTERFACE,
                "libvirt" : COLLECTD_PLUGIN_LIBVIRT,
                "memory" : COLLECTD_PLUGIN_MEMORY,
                "uptime" : COLLECTD_PLUGIN_UPTIME,
                }
            self.view.plugins = plugins

            self.view.cpu_type_instance = COLLECTD_CPU_TYPE_INSTANCE
            self.view.memory_type_instance = COLLECTD_MEMORY_TYPE_INSTANCE
            self.view.df_ds = COLLECTD_DF_DS
            self.view.disk_type = COLLECTD_DISK_TYPE
            self.view.disk_ds = COLLECTD_DISK_DS
            self.view.interface_type = COLLECTD_INTERFACE_TYPE
            self.view.interface_ds = COLLECTD_INTERFACE_DS
            self.view.value_bounds_upper = VALUE_BOUNDS_UPPER
            self.view.value_bounds_lower = VALUE_BOUNDS_LOWER

            return True


        if not validates_query(self):
            self.logger.debug("Show watch is failed, "
                              "Invalid query value "
                              "- query=%s" % self.input.q)
            return web.badrequest(self.view.alert)

        if not validates_page(self):
            self.logger.debug("Show watch is failed, "
                              "Invalid page value - page=%s" % self.input.p)
            return web.badrequest(self.view.alert)

        if is_param(self.input, 'q') is True:
            watchs = w_findbyand(self.orm, self.input.q)
            if not watchs:
                self.logger.debug("Show watch is failed, "
                                  "Could not find watch "
                                  "- query=%s" % self.input.q)
                return web.nocontent()
            self.view.search_value = self.input.q
        else:
            watchs = w_findbyall(self.orm)
            self.view.search_value = ""

        if is_param(self.input, 'p') is True:
            start = int(self.input.p)
        else:
            start = 0

        pager = Pager(watchs, start, WATCH_LIST_RANGE)
        if not pager.exist_now_page() and is_param(self.input, 'p') is True:
            self.logger.debug("Show watch is failed, "
                              "Could not find page - page=%s" % self.input.p)
            return web.nocontent()

        self.view.pager = pager
        self.view.input = self.input

        return True

    @auth
    def _POST(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        if not validates_watch(self):
            return web.badrequest(self.view.alert)

        plugin = self.input.watch_target
        plugin_instance = None
        type = None
        type_instance = None
        plugin_ds = None

        if plugin == COLLECTD_PLUGIN_CPU:
            #cpu method
            plugin_instance = self.input.logical_cpu_number
            type_instance = self.input.cpu_status
            type = COLLECTD_CPU_TYPE
            plugin_ds = COLLECTD_CPU_DS

        elif plugin == COLLECTD_PLUGIN_MEMORY:
            #memory method
            type_instance = self.input.memory_status
            type = COLLECTD_MEMORY_TYPE
            plugin_ds = COLLECTD_MEMORY_DS

        elif plugin == COLLECTD_PLUGIN_DF:
            #df method
            type = COLLECTD_DF_TYPE
            type_instance = self.input.df_target_disk
            plugin_ds = self.input.df_disk_status

        elif plugin == COLLECTD_PLUGIN_DISK:
            #disk method
            plugin_instance = self.input.disk_target_disk
            type = self.input.disk_disk_status
            plugin_ds = self.input.disk_value_type

        elif plugin == COLLECTD_PLUGIN_INTERFACE:
            #interface method
            type = self.input.network_status
            type_instance = self.input.network_target_interface
            plugin_ds = self.input.network_direction

        elif plugin == COLLECTD_PLUGIN_LIBVIRT:
            #libvirt method
            if self.input.libvirt_target == "cpu":
                if self.input.libvirt_vcpu_target == "total":
                    type = COLLECTD_LIBVIRT_TYPE['CPU_TOTAL']
                else:
                    type = COLLECTD_LIBVIRT_TYPE['VCPU']
                    type_instance = self.input.libvirt_vcpu_target

                plugin_ds = COLLECTD_CPU_DS

            elif self.input.libvirt_target == "disk":
                type = "disk_" + self.input.libvirt_disk_status
                type_instance = self.input.libvirt_disk_target
                plugin_ds = self.input.libvirt_disk_value_type

            elif self.input.libvirt_target == "network":
                type = "if_" + self.input.libvirt_network_status
                type_instance = self.input.libvirt_target_interface
                plugin_ds = self.input.libvirt_network_direction

        elif plugin == COLLECTD_PLUGIN_UPTIME:
            #uptime method
            type = COLLECTD_UPTIME_TYPE
            plugin_ds = COLLECTD_UPTIME_DS

        plugin_selector = create_plugin_selector(plugin_instance, type, type_instance)
        _watch = w_new(created_user=self.me,
                       modified_user=self.me,
                       machine_id=host_id,
                       name=self.input.watch_name,
                       plugin=plugin,
                       plugin_selector=plugin_selector,
                       karesansui_version=get_karesansui_version(),
                       collectd_version=get_collectd_version(),
                       is_deleted=False,
                       )
        w_save(self.orm, _watch)

        value_count = int(self.input.value_count)
        count = 1
        while(count <= value_count):
            value = eval("self.input.threshold_value_" + str(count))
            value_bounds = eval("self.input.value_bounds_" + str(count))
            shell = eval("self.input.shell_script_" + str(count))

            value_selector = create_value_selector(plugin_ds, value, value_bounds)

            _wd = wd_new(created_user=self.me,
                         modified_user=self.me,
                         watch=_watch,
                         value_selector=value_selector,
                         shell=shell,
                         )

            wd_save(self.orm, _wd)
            count += 1


        return web.created(None)

urls = (
    '/host/(\d+)/watch/?(\.part)$', HostBy1Watch,
    )
