# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import web

from karesansui.lib.rest import Rest, auth
from karesansui.lib.pager import Pager, validates_page
from karesansui.lib.search import validates_query
from karesansui.lib.const import \
    ID_MIN_LENGTH, ID_MAX_LENGTH

from karesansui.db.access.watch import \
    findby1 as w_findby1, logical_delete

from karesansui.db.access.watchdetail import \
    findbywatch as wd_findbywatch

from karesansui.lib.checker import Checker, \
    CHECK_EMPTY, CHECK_VALID, \
    CHECK_LENGTH, CHECK_MIN, CHECK_MAX

from karesansui.lib.utils import is_param

def validates_watch(obj):
    check = True
    return check

def validates_param_id(obj, watch_id):
    checker = Checker()
    check = True

    _ = obj._
    checker.errors = []

    check = checker.check_number(
            _('Watch ID'),
            watch_id,
            CHECK_EMPTY | CHECK_VALID | CHECK_MIN | CHECK_MAX,
            min = ID_MIN_LENGTH,
            max = ID_MAX_LENGTH,
            ) and check

    obj.view.alert = checker.errors
    return check


class HostBy1WatchBy1(Rest):

    @auth
    def _GET(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        watch_id = param[1]

        watch = w_findby1(self.orm, watch_id)
        self.view.info = watch

        details = wd_findbywatch(self.orm, watch_id)
        self.view.details = details

        return True

    @auth
    def _PUT(self, *param, **params):
        return web.seeother(web.ctx.path)

    @auth
    def _DELETE(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        watch_id = param[1]

        if not validates_param_id(self, watch_id):
            self.logger.debug("Update watch is failed, Invalid param value.")
            return web.notfound(self.view.alert)


        watch = w_findby1(self.orm, watch_id)
        if not watch:
            self.logger.debug("Delete watch is failed, "
                              "Did not exist watch - id=%s" % watch_id)
            return web.notfound()

        logical_delete(self.orm, watch)
        return web.seeother(web.ctx.path)

urls = (
    '/host/(\d+)/watch/(\d+)/?(\.part)$', HostBy1WatchBy1,
    )
