#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

import math

import karesansui

DEFAULT_LANGS = {"ja_JP": {'DATE_FORMAT' : ("%Y/%m/%d", "%Y/%m/%d %H:%M:%S", "yy-mm-dd")},
                 "en_US": {'DATE_FORMAT' : ("%m/%d/%Y", "%m/%d/%Y %H:%M:%S", "mm-dd-yy")},
                 }
"""<comment-ja>
DATE_FORMAT
 - [年月日, 年月日時分秒, jquery.ui.datepicker,]
</comment-ja>
<comment-en>
TODO: English Comment
</comment-en>
"""

# define karesansui paths & users
KARESANSUI_USER  = "kss"
KARESANSUI_GROUP = "kss"
KARESANSUI_PREFIX = "/opt/karesansui"
KARESANSUI_TMP_DIR     = KARESANSUI_PREFIX + "/tmp"
KARESANSUI_SYSCONF_DIR = "/etc/opt/karesansui"
KARESANSUI_DATA_DIR    = "/var/opt/karesansui"

MACHINE_ATTRIBUTE = {'HOST':0,
                     'GUEST':1,
                    }
MACHINE_HYPERVISOR = {'REAL':0,
                      'XEN':1,
                      'KVM':2,
                     }

# define vendor paths
VENDOR_PREFIX      = "/opt/hde"
VENDOR_SYSCONF_DIR = "/etc/opt/hde"
VENDOR_DATA_DIR    = "/var/opt/hde"
VENDOR_LIBVIRT_RUN_DIR = "/var/run/hde-libvirt"
XEN_SYSCONF_DIR    = "/etc/xen"

#LOGOUT_FILE_PREFIX = "%s/logout." % karesansui.config['application.tmp.dir']
LOGOUT_FILE_PREFIX = KARESANSUI_TMP_DIR + "/logout."
ICON_DIR_TPL = "%s/static/icon/%s"
MSG_LIMIT = 5
TAG_CLIPPING_RANGE = 12
MACHINE_NAME_CLIPPING_RANGE = 20

DEFAULT_LIST_RANGE = 10
JOB_LIST_RANGE = DEFAULT_LIST_RANGE
USER_LIST_RANGE = DEFAULT_LIST_RANGE
TAG_LIST_RANGE = DEFAULT_LIST_RANGE
WATCH_LIST_RANGE = DEFAULT_LIST_RANGE
MAILTEMPLATE_LIST_RANGE = DEFAULT_LIST_RANGE

# use for virt library
VIRT_LIBVIRT_DATA_DIR    = VENDOR_DATA_DIR + "/libvirt"
VIRT_XENDOMAINS_AUTO_DIR = XEN_SYSCONF_DIR + "/auto"

VIRT_LIBVIRT_SOCKET_RW = VENDOR_LIBVIRT_RUN_DIR + "/libvirt-sock";
VIRT_LIBVIRT_SOCKET_RO = VENDOR_LIBVIRT_RUN_DIR + "/libvirt-sock-ro";

# kvm
KVM_VIRTUAL_DISK_PREFIX = "hd"
KVM_VIRT_CONFIG_DIR  = VENDOR_SYSCONF_DIR + "/kvm"
#KVM_VIRT_URI_RW = "qemu+tls://127.0.0.1:16514/system?no_verify=1"
#KVM_VIRT_URI_RO = "qemu+tls://127.0.0.1:16514/system?no_verify=1"
KVM_VIRT_URI_RW = "qemu+tls://127.0.0.1:16514/system"
KVM_VIRT_URI_RO = "qemu+tls://127.0.0.1:16514/system"
KVM_KARESANSUI_TMP_DIR = KARESANSUI_TMP_DIR + "/kvm"
KVM_KEYMAP_DIR = '/usr/share/kvm/keymaps'

# xen
XEN_VIRTUAL_DISK_PREFIX = "xvd"
XEN_VIRT_CONFIG_DIR  = VENDOR_SYSCONF_DIR + "/xen"
XEN_VIRT_URI_RW = "xen:///?socket=" + VIRT_LIBVIRT_SOCKET_RW
XEN_VIRT_URI_RO = "xen:///?socket=" + VIRT_LIBVIRT_SOCKET_RO
XEN_KARESANSUI_TMP_DIR = KARESANSUI_TMP_DIR + "/xen"
XEN_KEYMAP_DIR = '/usr/share/xen/qemu/keymaps'

VIRT_XML_CONFIG_DIR  = VENDOR_SYSCONF_DIR + "/libvirt/qemu"

VIRT_SYSCONF_DIR = VENDOR_SYSCONF_DIR + "/libvirt"
OLD_VIRT_DISK_DIR       = VIRT_LIBVIRT_DATA_DIR + "/disk"
OLD_VIRT_DISK_IMAGE_DIR = VIRT_LIBVIRT_DATA_DIR + "/images"
OLD_VIRT_BOOT_IMAGE_DIR = VIRT_LIBVIRT_DATA_DIR + "/boot"
OLD_VIRT_SNAPSHOT_DIR   = VIRT_LIBVIRT_DATA_DIR + "/snapshot"
VIRT_DOMAINS_DIR        = VIRT_LIBVIRT_DATA_DIR + "/domains"
VIRT_NETWORK_CONFIG_DIR = VIRT_SYSCONF_DIR + "/qemu/networks"
VIRT_AUTOSTART_CONFIG_DIR = VIRT_SYSCONF_DIR + "/qemu/autostart"
VIRT_LIBVIRTD_CONFIG_FILE = VIRT_SYSCONF_DIR + "/libvirtd.conf"
VIRT_STORAGE_CONFIG_DIR = VIRT_SYSCONF_DIR + "/storage"
VIRT_STORAGE_AUTOSTART_CONFIG_DIR = VIRT_SYSCONF_DIR + "/storage/autostart"

# virt command
VIRT_COMMAND_APPLY_SNAPSHOT = "apply_snapshot.py"
VIRT_COMMAND_CREATE_GUEST = "create_guest.py"
VIRT_COMMAND_DELETE_GUEST = "delete_guest.py"
VIRT_COMMAND_DELETE_SNAPSHOT = "delete_snapshot.py"
VIRT_COMMAND_GET_MEMORY_USAGE = "get_memory_usage.py"
VIRT_COMMAND_SET_MEMORY = "set_memory.py"
VIRT_COMMAND_START_GUEST = "start_guest.py"
VIRT_COMMAND_REBOOT_GUEST = "reboot_guest.py"
VIRT_COMMAND_DESTROY_GUEST = "destroy_guest.py"
VIRT_COMMAND_AUTOSTART_GUEST = "autostart_guest.py"
VIRT_COMMAND_CREATE_NETWORK = "create_network.py"
VIRT_COMMAND_DELETE_NETWORK = "delete_network.py"
VIRT_COMMAND_UPDATE_NETWORK = "update_network.py"
VIRT_COMMAND_REPLICATE_GUEST = "replicate_guest.py"
VIRT_COMMAND_EXPORT_GUEST = "export_guest.py"
VIRT_COMMAND_IMPORT_GUEST = "import_guest.py"
VIRT_COMMAND_DELETE_EXPORT_DATA = "delete_export_data.py"
VIRT_COMMAND_SET_VCPUS = "set_vcpus.py"
VIRT_COMMAND_SUSPEND_GUEST = "suspend_guest.py"
VIRT_COMMAND_ADD_DISK = "add_disk.py"
VIRT_COMMAND_APPEND_DISK = "append_disk.py"
VIRT_COMMAND_DELETE_DISK = "delete_disk.py"
VIRT_COMMAND_ADD_NIC = "add_nic.py"
VIRT_COMMAND_DELETE_NIC = "delete_nic.py"
VIRT_COMMAND_CPUTOP = "cputop.py"
VIRT_COMMAND_GET_CPU_USAGE = "get_cpu_usage.py"
VIRT_COMMAND_RESUME_GUEST = "resume_guest.py"
VIRT_COMMAND_SHUTDOWN_GUEST = "shutdown_guest.py"
VIRT_COMMAND_TAKE_SNAPSHOT = "take_snapshot.py"
VIRT_COMMAND_SET_MAC_ADDRESS = "set_mac_address.py"
VIRT_COMMAND_SET_VNC = "set_vnc.py"
FIREWALL_COMMAND_SAVE_FIREWALL = "save_firewall.py"
FIREWALL_COMMAND_RESTORE_FIREWALL = "restore_firewall.py"
UPDATE_COMMAND_SOFTWARE="update_software.py"
VIRT_COMMAND_CREATE_STORAGE_POOL = "create_storage_pool.py"
VIRT_COMMAND_DELETE_STORAGE_POOL = "delete_storage_pool.py"
VIRT_COMMAND_START_STORAGE_POOL = "start_storage_pool.py"
VIRT_COMMAND_DESTROY_STORAGE_POOL = "destroy_storage_pool.py"
VIRT_COMMAND_CREATE_STORAGE_VOLUME = "create_storage_volume.py"
VIRT_COMMAND_DELETE_STORAGE_VOLUME = "delete_storage_volume.py"
ISCSI_COMMAND_GET = "get_iscsi.py"
ISCSI_COMMAND_ADD = "add_iscsi.py"
ISCSI_COMMAND_DELETE = "delete_iscsi.py"
ISCSI_COMMAND_START = "start_iscsi.py"
ISCSI_COMMAND_STOP = "stop_iscsi.py"
ISCSI_COMMAND_UPDATE = "update_iscsi.py"
CONFIGURE_COMMAND_READ = "read_conf.py"
CONFIGURE_COMMAND_WRITE = "write_conf.py"
IPTABLES_COMMAND_CONTROL = "control_iptables.py"

# use for firewall library
FIREWALL_XML_FILE  = KARESANSUI_SYSCONF_DIR + "/firewall.xml"
FIREWALL_USERCHAIN = "KARESANSUI-Firewall"
RH_USERCHAIN = "RH-Firewall-1-INPUT"

# Proxy Server use Status
PROXY_ENABLE = '1'
PROXY_DISABLE = '0'

# lighttpd config
LIGHTTPD_COMMAND_UPDATE_CONFIG = "apply_lighttpdconf.py"
LIGHTTPD_CONF_TEMP_DIR = KARESANSUI_TMP_DIR + "/lighttpd"
LIGHTTPD_DEFAULT_PORT = 80
LIGHTTPD_DEFAULT_SSL = "disable"
LIGHTTPD_DEFAULT_ACCESS = "all"
LIGHTTPD_PORT_CONFIG = "port.conf"
LIGHTTPD_ACCESS_CONFIG = "access.conf"
LIGHTTPD_SSL_CONFIG = "ssl.conf"
LIGHTTPD_SSL_ON = "enable"
LIGHTTPD_SSL_OFF = "disable"

# port number
PORT_MIN_NUMBER = 1
PORT_MAX_NUMBER = 65535
WELKNOWN_PORT_MIN_NUMBER = 1
WELKNOWN_PORT_MAX_NUMBER = 1024
UNKNOWN_PORT_MIN_NUMBER = 1025
UNKNOWN_PORT_MAX_NUMBER = 65535
VNC_PORT_MIN_NUMBER = 5900
VNC_PORT_MAX_NUMBER = PORT_MAX_NUMBER

# input value length
ID_MIN_LENGTH = 1
ID_MAX_LENGTH = int(math.pow(2, 31)) - 1  # signed int max (2^31-1) SQLAlchemy SQLType.Integer
USER_MIN_LENGTH = 1
USER_MAX_LENGTH = 16
EMAIL_MIN_LENGTH = 1 + 1 + 4
EMAIL_MAX_LENGTH = 256
PASSWORD_MIN_LENGTH = 4
PASSWORD_MAX_LENGTH = 40
LANGUAGES_MIN_LENGTH = 1
LANGUAGES_MAX_LENGTH = 6
TAG_MIN_LENGTH = 1
TAG_MAX_LENGTH = 24
SEARCH_MIN_LENGTH = 0
SEARCH_MAX_LENGTH = 256
PAGE_MIN_SIZE = 0
PAGE_MAX_SIZE = int(math.pow(2, 31)) - 1  # signed int max (2^31-1)
MACHINE_NAME_MIN_LENGTH = 1
MACHINE_NAME_MAX_LENGTH = 256
HYPERVISOR_MIN_SIZE = 0
HYPERVISOR_MAX_SIZE = 2
MEMORY_MIN_SIZE = 64
DISK_MIN_SIZE = 1
CHECK_DISK_QUOTA = 0.95
DOMAIN_NAME_MIN_LENGTH = 1
DOMAIN_NAME_MAX_LENGTH = 32
NOTE_TITLE_MIN_LENGTH = 0
NOTE_TITLE_MAX_LENGTH = 64
IMAGE_EXT_LIST = ["gif", "png", "jpeg"]
VCPUS_MIN_SIZE = 1
FQDN_MIN_LENGTH = 0
FQDN_MAX_LENGTH = 256
CHAP_USER_MIN_LENGTH = 1
CHAP_USER_MAX_LENGTH = 256
CHAP_PASSWORD_MIN_LENGTH = 1
CHAP_PASSWORD_MAX_LENGTH = 256
STORAGE_VOLUME_SIZE_MIN_LENGTH = 0;
STORAGE_VOLUME_SIZE_MAX_LENGTH = 9999999;

DEFAULT_KEYMAP = 'en-us'

STORAGE_POOL_TYPE = {"TYPE_DIR":"dir",
                     "TYPE_FS":"fs",
                     "TYPE_NETFS":"netfs",
                     "TYPE_LOGICAL":"logical",
                     "TYPE_DISK":"disk",
                     "TYPE_ISCSI":"iscsi",
                     "TYPE_SCSI":"scsi",
                     }

STORAGE_VOLUME_FORMAT = {"TYPE_RAW":"raw",
                  "TYPE_QCOW2":"qcow2",
                  "TYPE_QCOW":"qcow",
                  "TYPE_COW":"cow",
                  "TYPE_VDI":"vdi",
                  "TYPE_VMDK":"vmdk",
                  "TYPE_VPC":"vpc",
                  "TYPE_CLOOP":"cloop",
                  }

STORAGE_VOLUME_UNIT = {"B":1,
                       "K":1024,
                       "M":1048576,
                       "G":1073741824,
                       "T":1099511627776,
                       "P":1125899906842624,
                       "E":1152921504606846976,
                      }

# Disk format
DISK_QEMU_FORMAT = {"RAW" : "raw",
                    "QCOW2" : "qcow2",
                    "QCOW" : "qcow",
                    "COW" : "cow",
                    "VMDK" : "vmdk",
                    }

DISK_NONE_QEMU_FORMAT = {"RAW" : "raw",}

# iSCSI
ISCSI_DEFAULT_CONFIG_PATH = "/etc/iscsi/iscsid.conf"
ISCSI_DEFAULT_NODE_CONFIG_DIR = "/var/lib/iscsi/nodes"
ISCSI_CONFIG_KEY_AUTH_METHOD = "node.session.auth.authmethod"
ISCSI_CONFIG_KEY_AUTH_USER = "node.session.auth.username"
ISCSI_CONFIG_KEY_AUTH_PASSWORD = "node.session.auth.password"
ISCSI_CONFIG_KEY_SATRTUP = "node.startup"
ISCSI_CONFIG_VALUE_AUTH_METHOD_NONE = "None"
ISCSI_CONFIG_VALUE_AUTH_METHOD_CHAP = "CHAP"
ISCSI_CONFIG_VALUE_SATRTUP_ON = "automatic"
ISCSI_CONFIG_VALUE_SATRTUP_OFF = "manual"

ISCSI_CMD = "/sbin/iscsiadm"
ISCSI_CMD_OPTION_MODE = "--mode"
ISCSI_CMD_OPTION_MODE_NODE = "node"
ISCSI_CMD_OPTION_MODE_SESSION = "session"
ISCSI_CMD_OPTION_MODE_DISCOVERY = "discovery"
ISCSI_CMD_OPTION_TYPE = "--type"
ISCSI_CMD_OPTION_TYPE_SENDTARGETS = "sendtargets"
ISCSI_CMD_OPTION_OPERATOR = "--op"
ISCSI_CMD_OPTION_OPERATOR_DELETE = "delete"
ISCSI_CMD_OPTION_TARGETNAME = "--targetname"
ISCSI_CMD_OPTION_PORTAL = "--portal"
ISCSI_CMD_OPTION_LOGIN = "--login"
ISCSI_CMD_OPTION_LOGOUT = "--logout"
ISCSI_CMD_RES_NO_NODE = "no records found"
ISCSI_CMD_RES_NO_ACTIVE_SESSION = "No active sessions"

DEFAULT_KVM_DISK_FORMAT = "qcow2"
DEFAULT_XEN_DISK_FORMAT = "raw"

BUS_KVM_TYPE = {"IDE":"ide",
                "SCSI":"scsi",
                "VIRTIO":"virtio",
                }
BUS_XEN_TYPE = {"XEN":"xen",}

# Collectd
COLLECTD_VERSION = "4.9.1"

COLLECTD_PLUGIN_CPU = "cpu"
COLLECTD_PLUGIN_DF = "df"
COLLECTD_PLUGIN_DISK = "disk"
COLLECTD_PLUGIN_EXEC = "exec"
COLLECTD_PLUGIN_INTERFACE = "interface"
COLLECTD_PLUGIN_IPTABLES = "iptables"
COLLECTD_PLUGIN_LIBVIRT = "libvirt"
COLLECTD_PLUGIN_LOAD = "load"
COLLECTD_PLUGIN_LOGFILE = "logfile"
COLLECTD_PLUGIN_MEMORY = "memory"
COLLECTD_PLUGIN_NETWORK = "network"
COLLECTD_PLUGIN_PYTHON = "python"
COLLECTD_PLUGIN_RRDCACHED = "rrdcached"
COLLECTD_PLUGIN_RRDTOOL = "rrdtool"
COLLECTD_PLUGIN_SENSORS = "sensors"
COLLECTD_PLUGIN_SNMP = "SNMP"
COLLECTD_PLUGIN_SYSLOG = "syslog"
COLLECTD_PLUGIN_TAIL = "tail"
COLLECTD_PLUGIN_UPTIME = "uptime"
COLLECTD_PLUGIN_USERS = "users"

COLLECTD_CPU_TYPE = "cpu"
COLLECTD_CPU_TYPE_INSTANCE = {"IDLE" : "idle",
                              "NICE" : "nice",
                              "USER" : "user",
                              "WAIT" : "wait",
                              "INTERRUPT" : "interrupt",
                              "SOFTIRQ" : "softirq",
                              "STEAL" : "steal",
                              "SYSTEM" : "system",
                              }
COLLECTD_CPU_DS = "value"
COLLECTD_MEMORY_TYPE = "memory"
COLLECTD_MEMORY_TYPE_INSTANCE = {"FREE" : "free",
                                 "CACHED" : "cached",
                                 "BUFFERED" : "buffered",
                                 "USED" : "used",
                                 }
COLLECTD_MEMORY_DS = "value"
COLLECTD_DF_TYPE = "df"
COLLECTD_DF_DS = {"USED" : "used",
                  "FREE" : "free",
                  }
COLLECTD_DISK_TYPE = {"MERGED" : "disk_merged",
                      "OCTETS" : "disk_octets",
                      "OPS" : "disk_ops",
                      "TIME" : "disk_time",
                      }
COLLECTD_DISK_DS = {"READ" : "read",
                    "WRITE" : "write",
                    }
COLLECTD_INTERFACE_TYPE = {"ERRORS" : "if_errors",
                           "PACKETS" : "if_packets",
                           "OCTETS" : "if_octets",
                           }
COLLECTD_INTERFACE_DS = {"RX" : "rx",
                         "TX" : "tx",
                         }
COLLECTD_UPTIME_TYPE ="uptime"
COLLECTD_UPTIME_DS = "value"

COLLECTD_LOAD_TYPE = "load"
COLLECTD_LOAD_DS = {"SHORTTERM": "shortterm",
                    "MIDTERM"  : "midterm",
                    "LONGTERM" : "longterm",
                   }

COLLECTD_USERS_TYPE ="users"
COLLECTD_USERS_DS = "users"

COLLECTD_LIBVIRT_TYPE = {"CPU_TOTAL" : "virt_cpu_total",
                         "VCPU" : "virt_vcpu",
                         "DISK_OPS" : "disk_ops",
                         "DISK_OCTETS" : "disk_octets",
                         "IF_OCTETS" : "if_octets",
                         "IF_PACKETS" : "if_packets",
                         "IF_ERRORS" : "if_errors",
                         "IF_DROPPED" : "if_dropped",
                         }

COUNTUP_DATABASE_PATH = KARESANSUI_DATA_DIR + "/notify_count.db"
VALUE_BOUNDS_UPPER = "1"
VALUE_BOUNDS_LOWER = "0"

HDD_TYPES_REGEX = ('sd[a-z]+[0-9]*',
                   'hd[a-z]+[0-9]*',
                   )

DEFAULT_POOL = 'default'

STORAGE_POOL_PWD = {"OWNER":"root",
                    "GROUP":"kss",
                    "MODE":"0770",
                    }

STORAGE_VOLUME_PWD = {"OWNER":"root",
                      "GROUP":"kss",
                      "MODE":"0660",
                      }

DISK_USES = {"GUEST_OS":"guestos",
             "ADD_DISK":"adddisk",
             }
