﻿using System;
using System.Reflection;
using System.Text;
using System.Windows.Forms;

namespace Kasuga
{
    public class Debug
    {
        public static void Show(Exception exception, Assembly assembly, MethodBase method)
        {
            StringBuilder builder = new StringBuilder();
            string assemblyName = assembly.GetName().Name;
            string version = assembly.GetName().Version.ToString();
            string className = method.DeclaringType.FullName;
            string methodName = method.Name;
            string message = exception.Message;
            builder.Append("アセンブリ名：").Append(assemblyName).AppendLine();
            builder.Append("バージョン：").Append(version).AppendLine();
            builder.Append("クラス名：").Append(className).AppendLine();
            builder.Append("メソッド名：").Append(methodName).AppendLine();
            builder.Append("エラー内容：").Append(message).AppendLine();
            builder.Append(exception.StackTrace).AppendLine();
            MessageBox.Show(builder.ToString());
        }
    }
}
