﻿///@brief
///@author
///@date 2011/03/10 11:48:02(木)
#ifndef KFX_DEBUGTIMER_H
#define KFX_DEBUGTIMER_H
namespace KFX{
///デバッグ用(FPS計測)タイマーインターフェイス
class KDebugTimer{
	private:
		KDebugTimer(const KDebugTimer& );
		KDebugTimer& operator=(const KDebugTimer&);
	protected:
		KDebugTimer(){};	
	public:
		virtual ~KDebugTimer(){}
		///前回計測からどれくらいの時間がかかったかをミリ秒で返す
		virtual long long Get()=0;
		unsigned int GetFPS();
};

class IDebugTimerFactory{
private:
	IDebugTimerFactory(const IDebugTimerFactory&);
	IDebugTimerFactory& operator=(const IDebugTimerFactory&);
protected:
	IDebugTimerFactory(){}
public:
	virtual KDebugTimer* CreateTimer()=0;
	virtual ~IDebugTimerFactory(){}
	static IDebugTimerFactory& Instance();
};
}//end of namespace KFX
#endif
