﻿#include"debugconsole.h"
#include<sstream>
#include<windows.h>
namespace KFX{

DebugConsole::DebugConsole(){
	//デフォルトロガー
	class DefaultLogger : public ILogger{
	public:
		void Out(const char* str)const{
			::OutputDebugStringA(str);
		}
		void Out(const wchar_t* str)const{
			::OutputDebugString(str);
		}
		void Out(const int i)const{
			std::ostringstream stream;
			stream<<i;
			::OutputDebugStringA(stream.str().c_str());
		}
		void OutLine(){
			::OutputDebugStringA("\n");
		}
	};
	_logger.Reset(new DefaultLogger);
}

DebugConsole& DebugConsole::Instance(){
	static DebugConsole instance;
	return instance;
}

DebugConsole&
DebugConsole::Out(const char* str){
	_logger->Out(str);
	return *this;
}

DebugConsole&
DebugConsole::Out(const wchar_t* str){
	_logger->Out(str);
	return *this;
}

DebugConsole&
DebugConsole::Out(const int i){
	_logger->Out(i);
	return *this;
}
DebugConsole&
DebugConsole::OutLine(){
	_logger->OutLine();
	return *this;
}

DebugConsole&
DebugConsole::OutputLastError(const wchar_t* additionalMsg){
	LPVOID messageBuffer=NULL;
	FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		::GetLastError(),
		MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),
		(LPWSTR)&messageBuffer,
		0,
		NULL
		);
	_logger->Out((LPWSTR)messageBuffer);
	LocalFree(messageBuffer);
	_logger->Out(additionalMsg);
	return *this;
}

}// end of namespace KFX