﻿#ifndef KFX_GAME_NODE_H_INCLUDED
#define KFX_GAME_NODE_H_INCLUDED
#include<list>

namespace KFX{

///実行されるノード基底クラス
///@note こいつの基本ルールは、自分で死ぬことはできない。
///殺すことができるのはRootNodeのみである(いや死ねるけどね)
///いわゆる純粋仮想関数を持つ基底クラス
class GameNode{
	private:
		bool _isDead;
		//ノードはコピー、代入禁止にしとく
		///@note コピーコンストラクタ、代入オペレータをprivateにして使用禁止にするのは
		///基本テクニックの一つ
		GameNode(const GameNode& );
		GameNode& operator=(const GameNode& );
	protected:
		void Dispose(){
			_isDead=true;
		}
	public:
		GameNode():_isDead(false){}
		bool IsDead() const{return _isDead;}
		///このノードは、デバイスに登録されると毎フレーム実行される
		///純粋仮想関数である
		virtual void Update()=0;
		///更新された後(描画後)に呼び出される
		virtual void OnUpdated(){};
};

///GameNodeを管理する
///@note RootNodeはノードという名前ではあるが、別にノードになっているわけじゃない
///GameNodeのリストを内包しているだけだ
class RootNode{
	private:
		std::list<GameNode*> _gamenodes;
		//コピー、代入の禁止
		RootNode(const RootNode& );
		RootNode& operator=(const RootNode&);
	public:
		RootNode(){}

		///実行すべきGameノードを追加する
		void AddNode(GameNode& gamenode);
		
		///子のGameNodeたちのUpdateメソッドを実行する
		void Update();
};
}//end of namespace KFX

#endif