﻿///@brief
///@date 2011/03/14 14:02:42(月)
#include"peripheral.h"
#include"../debugutil/debugconsole.h"
#include<windows.h>
#include<XInput.h>
#include<vector>
namespace KFX{

void
IPeripheral::AddListener(KInputListener* listener,int id){
	_listeners.push_back(listener);
}
///キーボードを使用した入力制御
class PeripheralWinKeyboard : public IPeripheral{
	private:
		InputStatus _inputStatus;
		
	public:
		PeripheralWinKeyboard();
		~PeripheralWinKeyboard();
		bool IsPressed(GameButtons buttons,int id)const;
		int AnalogValue(AnalogInputType inputType,int id)const;
		DirectionState CurrentDirection(int id)const;
		const InputStatus& CurrentInputStatus(int id)const;
		bool IsBinded()const;
		void CheckInput();
};

///XInputを使用した入力制御
class PeripheralXInput : public IPeripheral{
	private:
		std::vector<InputStatus> _inputStatuses;//
		XINPUT_STATE _state;
		KInputListener* _listener;//弱参照として扱う
	public:
		PeripheralXInput() : _listener(NULL){};
		bool IsPressed(GameButtons buttons,int id)const;
		int AnalogValue(AnalogInputType,int)const;
		DirectionState CurrentDirection(int id)const;
		const InputStatus& CurrentInputStatus(int id)const;
		void Bind(KInputListener* listener,int id);
		bool IsBinded()const;
		void CheckInput();
};

IPeripheral::DirectionState
PeripheralXInput::CurrentDirection(int id)const{
	return IPeripheral::DS_NEUTRAL;
}


void 
PeripheralXInput::CheckInput(){
	for(int i=0;i<4;++i){
		if(XInputGetState(i,&_state)==ERROR_SUCCESS){
			listeners_t::iterator it=_listeners.begin();
			listeners_t::iterator itEnd=_listeners.end();
			for(;it!=itEnd;++it){
				(*it)->OnPressed(*this);
			}
			break;
		}
	}
}

bool 
PeripheralXInput::IsBinded()const{
	return !_listeners.empty();
}

void 
PeripheralXInput::Bind(KInputListener* listener,int id){
	_listener=listener;//弱参照として扱う
}

int 
PeripheralXInput::AnalogValue(IPeripheral::AnalogInputType inputType,int id)const{
	switch(inputType){
		case IPeripheral::THUMB_LX:
			return _state.Gamepad.sThumbLX;
		case IPeripheral::THUMB_LY:
			return _state.Gamepad.sThumbLY;
		case IPeripheral::LEFT_TRIGGER:
			return _state.Gamepad.bLeftTrigger;
		case IPeripheral::RIGHT_TRIGGER:
			return _state.Gamepad.bRightTrigger;
		default:
			return 0;
	}
}

bool 
PeripheralXInput::IsPressed(GameButtons , int )const{
	return false;
}

const 
IPeripheral::InputStatus& PeripheralXInput::CurrentInputStatus(int ) const{
	return _inputStatuses[0];
}

PeripheralWinKeyboard::PeripheralWinKeyboard(){
	//通常キーボードはひとつのみなので、ひとつだけ登録
	_inputStatus=0;
}

PeripheralWinKeyboard::~PeripheralWinKeyboard(){
	DebugConsole::Instance().Out("destruct keyboard");
}

int 
PeripheralWinKeyboard::AnalogValue(AnalogInputType,int)const{
	return 0;
}

bool 
PeripheralWinKeyboard::IsPressed(GameButtons buttons,int id)const{
	return !!(_inputStatus & (1UL << buttons));
}


IPeripheral::DirectionState 
PeripheralWinKeyboard::CurrentDirection(int id)const{
	if( _inputStatus&GBMASK_LEFT ){
		if( _inputStatus&GBMASK_UP ){
			return DS_LEFTUP;
		}else if(_inputStatus&GBMASK_DOWN ){
			return DS_LEFTDOWN;
		}else{
			return DS_LEFT;
		}
	}else if(_inputStatus&GBMASK_RIGHT){
		if( _inputStatus&GBMASK_UP ){
			return DS_RIGHTUP;
		}else if(_inputStatus&GBMASK_DOWN ){
			return DS_RIGHTDOWN;
		}else{
			return DS_RIGHT;
		}
	}else{
		if( _inputStatus&GBMASK_UP ){
			return DS_UP;
		}else if(_inputStatus&GBMASK_DOWN ){
			return DS_DOWN;
		}else{
			return DS_NEUTRAL;
		}
	}
}

const IPeripheral::InputStatus& 
PeripheralWinKeyboard::CurrentInputStatus(int id)const{
	return _inputStatus;
}

bool 
PeripheralWinKeyboard::IsBinded()const{
	return !_listeners.empty();
}

void
PeripheralWinKeyboard::CheckInput(){
	BYTE state[256];
	///@todo ボタンはコンフィグに対応できるようにしておくべし
	if( ::GetKeyboardState(state)){
		_inputStatus = (state[VK_LEFT]&0x80 ? GBMASK_LEFT:0) | 
			(state[VK_UP]&0x80 ? GBMASK_UP:0) | 
			(state[VK_RIGHT]&0x80 ? GBMASK_RIGHT:0) | 
			(state[VK_DOWN]&0x80 ? GBMASK_DOWN:0) | 
			(state[static_cast<int>('Z')]&0x80 ? GBMASK_BUTTON_A:0) | 
			(state[static_cast<int>('X')]&0x80 ? GBMASK_BUTTON_B:0) | 
			(state[static_cast<int>('C')]&0x80 ? GBMASK_BUTTON_C:0) | 
			(state[static_cast<int>('A')]&0x80 ? GBMASK_BUTTON_D:0) | 
			(state[static_cast<int>('S')]&0x80 ? GBMASK_BUTTON_E:0) |
			(state[static_cast<int>('D')]&0x80 ? GBMASK_BUTTON_F:0);
		listeners_t::iterator it=_listeners.begin();
		listeners_t::iterator itEnd=_listeners.end();
		for(;it!=itEnd;++it){
			(*it)->OnPressed(*this);
		}
	}else{
		_inputStatus=0;
	}
}

KPeripheralListHolder::KPeripheralListHolder(){
	_periphList.resize(2);
	_periphList[0].Reset(new PeripheralWinKeyboard());
	_periphList[1].Reset(new PeripheralXInput());
}

std::vector<SharedPtr<IPeripheral> >&
KPeripheralListHolder::PeriphList(){
	return _periphList;
}
}//end of namespace KFX
