﻿#include<Windows.h>

#include<sstream>
#include"kernel/device/device_wrapper.h"
#include"game/scene/text_info_node.h"
#include"game/scene/mesh_node.h"
#include"game/Scene/player_node.h"
#include"game/Scene/bg_node.h"
#include"game/Scene/sprite_node.h"
#include"kernel/file/file.h"
#include"config/game_config.h"
#include"input/game_input.h"

using namespace KFX;


//メイン関数
//こればっかりは各プラットフォームで定義してやらにゃぁならん
int WINAPI WinMain(HINSTANCE ,HINSTANCE ,LPSTR ,int showCommand){
	KWindow window=KWindow::Instance();
	HWND handle = static_cast<HWND>(window.Handle());
	ShowWindow(handle,showCommand);
	UpdateWindow(handle);
	
	MSG msg;
	
	KDeviceWrapper& dev = KDeviceWrapper::Instance();
	if( !dev.IsAvailable() ){
		return 0;
	}
	
	MeshNode zaxis;
	BGNode bg;
	PlayerNode player(true);
	player.Load(L"animplane.x");
	zaxis.Load(L"human.x");
	zaxis.Move(Vector3D(0.f,0.f,10.f));
	bg.Load(L"sky2.x");
	GameInput& input = GameInput::Instance();

	dev.AddGameNode(player);
	dev.AddGameNode(zaxis);
	dev.AddGameNode(bg);
	input.AddListener(1,&player);
	//メッセージループ
	while(true){	
		if( PeekMessage(&msg,NULL,0,0,PM_REMOVE) ){
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		if(msg.message==WM_QUIT){
			break;
		}	
		input.Update();
		dev.Update();
	}
	return msg.wParam;
}
