#include"lua_script.h"

extern "C" {
#include"../lua/lua.h"
#include"../lua/lualib.h"
#include"../lua/lauxlib.h"
}

#include"../kernel/file/file.h"
#include"../util/string/stringbuffer.h"
#include"../debugutil/debugconsole.h"
#include<string>
namespace KFX{

KLuaScript::KLuaScript(const wchar_t *path){
	ScopedPtr<IResourceReader> reader=KResourceReaderProvider::Instance().Create(path);
	long long size = reader->FileSize();
	
	size_t readbytes;
	std::vector<char> buff(static_cast<unsigned int>(size));
	bool result = reader->Request(&buff[0],size,readbytes);
	if( result ){
		_state = lua_open();
		luaL_loadbuffer(_state,&buff[0],buff.size(),NULL);
		luaL_openlibs(_state);
		_stack.Reset(new KLuaStack(_state));
	}else{

	}
}

void
KLuaScript::GetField(const char* name){
	lua_getfield(_state,LUA_GLOBALSINDEX,name);
}

void
KLuaScript::GetField(const char* name,int idx){
	lua_getfield(_state,idx,name);
}

void
KLuaScript::Call(int numOfArgs,int numOfResults){
	int err = lua_pcall(_state,numOfArgs,numOfResults,0);
	if( err==LUA_ERRRUN ){
		const char* str = this->ToString();
		KStringBuffer sbuf(str);
		DebugConsole::Instance().Out(&(sbuf.Buffer()[0]));
	}
}


int 
KLuaScript::ToInteger(int idx){
	return lua_tointeger(_state,idx);
}

const char* 
KLuaScript::ToString(int idx){
	return lua_tostring(_state,idx);
}

bool
KLuaScript::ToBoolean(int idx){
	return static_cast<bool>(lua_toboolean(_state,idx)!=0);
}

void
KLuaStack::Push(const char* string){
	lua_pushstring(_state,string);
}
void 
KLuaStack::Pop(int num){
	lua_pop(_state,num);
}

int
KLuaStack::GetTop(){
	return lua_gettop(_state);
}

}//end of namespace KFX