﻿#include"game_config.h"
#include"../script/lua_script.h"
#include<cassert>
namespace KFX{
GameConfig::GameConfig(){
	KFX::KLuaScript script(L"systemconfig.lua");
	script.Call();
	InitProperties(script);
}
///@post stack.GetTop()==0
void 
GameConfig::InitProperties(KLuaScript& script){
	KFX::KLuaStack& stack=script.Stack();
	script.GetField("Screen");
	script.GetField("width",-1);
	_screenWidth = script.ToInteger(-1);
	stack.Pop(1);
	script.GetField("height",-1);
	_screenHeight = script.ToInteger(-1);
	stack.Pop(1);
	script.GetField("isFullScreen",-1);
	_isFullScreen = script.ToBoolean(-1);
	stack.Pop(2);
	assert(stack.GetTop()==0);
}

GameConfig&
GameConfig::Instance(){
		static GameConfig instance;
		return instance;
}

}//end of namespace KFX