﻿///@brief コンフィグ用プログラム
///@author ryu-prog
///@date 2011/03/01 12:02:12(火)
#ifndef KFX_GAMECONFIG_H
#define KFX_GAMECONFIG_H
namespace KFX{
class KLuaScript;
///ゲームのコンフィグにアクセスするクラス
///@attention このクラスは生成と同時にsystemconfig.luaを見に行くので
///生成のタイミングには気をつけること
class GameConfig{
private:
	int _screenWidth;
	int _screenHeight;
	bool _isFullScreen;
	///
	GameConfig();

	///@post stack.GetTop()==0
	void InitProperties(KLuaScript& script);
public:
	static GameConfig& Instance();

	///コンフィグで指定されている画面の幅を返す
	///@return 画面の幅
	int ScreenWidth()const{
		return _screenWidth;
	}

	///コンフィグで指定されている画面の高さを返す
	///@return 画面高さ
	int ScreenHeight()const{
		return _screenHeight;
	}

	///フルスクリーンかどうか
	///@retval true フルスクリーン表示
	///@retval false ウィンドウ表示
	bool IsFullScreen() const{
		return _isFullScreen;
	}
};
}//end of namespace KFX
#endif


