﻿#include<windows.h>
#include<mmsystem.h>
#include"debug_timer.h"
#include<cassert>
namespace KFX{

//FPSタイマは高い分解能を求められるわけでもないので
//timeGetTimeを使用
class DebugTimerWin32 : public KDebugTimer{
	private:
		long long _lastValue;
	public:
		DebugTimerWin32();
		long long Get();
		unsigned int GetFPS()const;
};

class DebugTimerFactoryWin32 : public IDebugTimerFactory{
public:
	KDebugTimer* CreateTimer(){
		return new DebugTimerWin32;
	}
};

IDebugTimerFactory& 
IDebugTimerFactory::Instance(){
	static DebugTimerFactoryWin32 instance;
	return instance;
}

DebugTimerWin32::DebugTimerWin32():_lastValue(0){
	
}

long long
DebugTimerWin32::Get(){
	long long retval=::timeGetTime()-_lastValue;
	_lastValue=::timeGetTime();
//	assert(retval);
	return retval;
}
unsigned int
KDebugTimer::GetFPS(){
	long long now = this->Get();
	if( now==0 ){
		return 0U;
	}
	return static_cast<unsigned int>(1000UL/(now));
}

}//end of namespace KFX

