///@date 2011/03/01 19:34:05()
#ifndef KFX_DEBUGCONSOLE_H
#define KFX_DEBUGCONSOLE_H

#include"../kernel/pointer/scoped_ptr.h"

namespace KFX{

///K[C^[tFCX
class ILogger{
	public:
		virtual void Out(const char*)const=0;
		virtual void Out(const wchar_t* )const=0;
		virtual void Out(const int i)const=0;
		virtual void OutLine()=0;
};

///fobOpR\[ɑ΂鑀񋟂܂B
///@note WindowsȂftHgŃR}hvvgɏo͂܂B
///ƂPS3ƂłTTYɏo͂悤ɂ܂(PS3JĂl͂ŎĂ)
///܂ASetLogger\bhŃK[w肷邱Ƃł܂(\)
///Out֐͂̃IuWFNggԂ߁AOut("five").Out("Four").Out("Three").Out("Two").Out("One")
///݂Ȏgł܂B
class DebugConsole{
	private:
		ScopedPtr<ILogger> _logger;
		DebugConsole();
		DebugConsole(const DebugConsole&);
		DebugConsole& operator=(const DebugConsole&);
	public:
		static DebugConsole& Instance();
		///K[ݒ肷BȑOɐݒ肵Ă郍K[͔j
		///@param ݒ肵K[
		void SetLogger(const ILogger* logger);

		///K[ɕo
		///@param str o͕
		///@return g
		DebugConsole& Out(const wchar_t* str);

		///K[ɕo
		///@param str o͕
		///@return g
		DebugConsole& Out(const char* str);

		///K[ɐlo
		///@param i o͐l
		///@return g
		DebugConsole& Out(const int i);
		
		DebugConsole&OutLine();
		///ŌɔG[o
		///@param additionalMsg ǋL
		///@return g
		DebugConsole& OutputLastError(const wchar_t* additionalMsg=L"");
};
}//end of namespace KFX
#endif
