﻿#include"sprite.h"
#include"../../kernel/device/device_wrapper.h"
#include<vector>
#include<d3dx9core.h>
namespace KFX{
class SpriteImplD3D : public ISprite{
private:
	LPD3DXSPRITE _sprite;
	D3DXVECTOR3 _position;
	std::vector<ITexture*> _textures;
public:
	SpriteImplD3D(ITexture* texture);
	~SpriteImplD3D();
	int AddTexture(ITexture* texture);
	int InsertTexture(ITexture* texture,int idx);
	void RemoveTexture(int idx);
	void Draw();

	void MoveX(const float x);
	void MoveY(const float y);

	void SetX(const int x){};
	void SetY(const int y){};
};

SpriteImplD3D::SpriteImplD3D(ITexture* texture):_position(0.f,0.f,0.f){
	AddTexture(texture);
	::D3DXCreateSprite(static_cast<LPDIRECT3DDEVICE9>(KDeviceWrapper::Instance().GetDevice()),&_sprite);
}

SpriteImplD3D::~SpriteImplD3D(){
	_sprite->Release();
}

void
SpriteImplD3D::MoveX(const float x){
	_position.x+=x;
}

void
SpriteImplD3D::MoveY(const float y){
	_position.y+=y;
}


int
SpriteImplD3D::AddTexture(ITexture* texture){
	_textures.push_back(texture);
	return _textures.size();
}

int
SpriteImplD3D::InsertTexture(ITexture* texture,int idx){
	_textures.insert(_textures.begin()+idx,texture);
	return _textures.size();
}

void
SpriteImplD3D::RemoveTexture(int idx){
}

void
SpriteImplD3D::Draw(){
	RECT rc={0,0,0,0};
	ITexture* texture = _textures.front();
	ITexture::Info info=texture->MipInfo();
	rc.right=info._width;
	rc.bottom=info._height;
	_sprite->Begin(D3DXSPRITE_ALPHABLEND);
	D3DXMATRIX mat;
	::D3DXMatrixScaling(&mat,2.f,2.f,1.f);
	_sprite->SetTransform(&mat);
	_sprite->Draw(static_cast<LPDIRECT3DTEXTURE9>(_textures[0]->Get()),
		NULL,
		&D3DXVECTOR3(16.f,16.f,0.f),
		&_position,
		0xffffffff);
	_sprite->End();
}

class SpriteFactoryImplD3D : public ISpriteFactory{
public:
	ISprite* CreateSprite(ITexture* texture);
};

ISpriteFactory&
ISpriteFactory::Instance(){
	static SpriteFactoryImplD3D instance;
	return instance;
}


ISprite* 
SpriteFactoryImplD3D::CreateSprite(ITexture* texture){
	
	return new SpriteImplD3D(texture);
}

}//end of namespace KFX

