﻿///@brief
///@author
///@date 2011/03/10 15:15:48(木)
#ifndef KFX_SPRITE_H
#define KFX_SPRITE_H
#include"../texture.h"
namespace KFX{

class ISprite{
	private:
	public:
		virtual ~ISprite(){}
		///テクスチャを追加する
		///@param texture 対象テクスチャ
		///@reture 追加後のテクスチャ数
		virtual int AddTexture(ITexture* texture)=0;

		///テクスチャを挿入する
		///@param texture 対象テクスチャ
		///@return 追加後のテクスチャ数
		virtual int InsertTexture(ITexture* texture,int idx)=0;
		virtual void RemoveTexture(int idx)=0;
		virtual void Draw()=0;

		virtual void MoveX(const float x){};
		virtual void MoveY(const float y){};

		virtual void SetX(const int x){};
		virtual void SetY(const int y){};

};
	
class ISpriteFactory{
	private:
		ISpriteFactory(const ISpriteFactory& );
		ISpriteFactory& operator=(const ISpriteFactory& );
	protected:
		ISpriteFactory(){}
	public:
		~ISpriteFactory(){}
		virtual ISprite* CreateSprite(ITexture* texture)=0;
		static ISpriteFactory& Instance();
};


}//end of namespace KFX
#endif
