﻿///@brief 幾何関係の構造体
///@author ryuichi kawano
#ifndef KFX_GEOMETORY_H
#define KFX_GEOMETORY_H


#ifdef WIN32


namespace KFX{
struct Vector3D{
	Vector3D(float ix=0,float iy=0,float iz=0):x(ix),y(iy),z(iz){}
	float x;
	float y;
	float z;
};
typedef Vector3D Point3D;
const float PI=3.141593f;

struct RollYawPitch{
	float roll;
	float yaw;
	float pitch;
};

}//end of namespace KFX
#endif
namespace KFX{
///矩形構造体(整数値用)
struct Rect{
	int left;
	int top;
	int right;
	int bottom;
	Rect();
	Rect(int inleft,int intop,int inright,int inbottom);
	void Set(int inleft,int intop, int inright,int inbottom);

	///矩形のX座標を設定する
	///幅には影響しない
	void SetX(int x);

	///矩形のY座標を設定する
	///高さには影響しない
	void SetY(int y);

	///@return 矩形の幅を返す
	int GetWidth() const;

	///@return 矩形の高さを返す
	int GetHeight() const;
};
}//end of namespace KFX
#endif
