﻿#include"texture.h"
#include"../kernel/device/device_wrapper.h"
#include"../debugutil/debugconsole.h"
#include<windows.h>
#include<d3d9.h>
#include<d3dx9.h>
namespace KFX{

class TextureImplD3D : public ITexture{
private:
	LPDIRECT3DTEXTURE9 _texture;
	LPDIRECT3DDEVICE9 _dev;
	D3DXMATRIX _mat;

public:
	TextureImplD3D(LPDIRECT3DTEXTURE9 texture):
		_texture(texture){
		texture->GetDevice(&_dev);
		D3DXMatrixIdentity(&_mat);
	}
	
	Info MipInfo(int level){
		D3DSURFACE_DESC desc;
		_texture->GetLevelDesc(level,&desc);
		Info info={desc.Width,desc.Height};
		return info;
	}
	//テクスチャの平行移動
	void Transform(const float u,const float v,const unsigned int stage){
		_dev->SetTextureStageState(stage,D3DTSS_TEXTURETRANSFORMFLAGS,D3DTTFF_COUNT2);
		D3DXMatrixIdentity(&_mat);
		_mat._31=u;
		_mat._32=v;
		_dev->SetTransform(D3DTS_TEXTURE0,&_mat);
	}
	void SetTextureAddressingMode(TextureAddressingMode admode,int sampler){
		D3DTEXTUREADDRESS address=D3DTADDRESS_WRAP;
		switch(admode){
			case Mirror:
				address=D3DTADDRESS_MIRROR;
				break;
			default:
				;
		}
		_dev->SetSamplerState(sampler,D3DSAMP_ADDRESSU ,address);
		_dev->SetSamplerState(sampler,D3DSAMP_ADDRESSV ,address);
	}
	void* Get() const{
		return _texture;
	}

	void Apply(int idx){
		_dev->SetTexture(idx,_texture);
	}
	//いじったUVを元に戻す
	void Neutralize(const unsigned int stage){
		_dev->SetTextureStageState(stage,D3DTSS_TEXTURETRANSFORMFLAGS,D3DTTFF_DISABLE);
	}

	~TextureImplD3D(){
		_texture->Release();
	}
};

class TextureBuilderD3D : public ITextureBuilder{
private:
	KDeviceWrapper& _dev;
public:
	TextureBuilderD3D():_dev(KDeviceWrapper::Instance()){}
	
	ITexture* CreateTextureFromFile(const char* filepath){
		LPDIRECT3DTEXTURE9 texture;
		HRESULT result = ::D3DXCreateTextureFromFileA(
					static_cast<LPDIRECT3DDEVICE9>(_dev.GetDevice()),
					filepath,
					&texture);
		if( SUCCEEDED(result) ){
			return new TextureImplD3D(texture);
		}else{
			DebugConsole::Instance().Out(L"Texture Failed");
			return NULL;
		}
		
	}

	ITexture* CreateTextureFromFile(const wchar_t* filepath){
		LPDIRECT3DTEXTURE9 texture;
		HRESULT result = ::D3DXCreateTextureFromFileW(
					static_cast<LPDIRECT3DDEVICE9>(_dev.GetDevice()),
					filepath,
					&texture);
		if( SUCCEEDED(result) ){
			return new TextureImplD3D(texture);
		}else{
			DebugConsole::Instance().Out(L"Texture Failed");
			return NULL;
		}
	}

	ITexture* CreateTextureFromMemory(const void* data){
		return NULL;
	}

};

ITextureBuilder& 
ITextureBuilder::Instance(){
	static TextureBuilderD3D instance;
	return instance;
}

}//end of namespace KFX
