﻿///@brief
///@author
///@date 2011/03/09 12:22:26(水)
#ifndef KFX_TEXTURE_H
#define KFX_TEXTURE_H
namespace KFX{
class ITextureBuilder;
///テクスチャインターフェイス
class ITexture{
	friend ITextureBuilder;
	private:
	public:
		struct Info{
			int _width;
			int _height;
		};
		virtual ~ITexture(){}
		enum TextureAddressingMode{
			Wrap,
			Mirror,
			Clamp,
			Border,
			MirrorOnce
		};
		virtual void SetTextureAddressingMode(TextureAddressingMode,int sampler=0)=0;

		///みっぷマップを返す
		virtual Info MipInfo(int level=0)=0;
		
		///テクスチャの平行移動を行う
		virtual void Transform(const float u,const float v,const unsigned int stage=0)=0;
		virtual void Neutralize(const unsigned int stage=0)=0;

		///デバイス依存テクスチャオブジェクトを返す
		///@return それぞれの環境に応じたテクスチャオブジェクトへのポインタ
		virtual void* Get() const=0;

		///テクスチャを適用する
		virtual void Apply(int idx=0)=0;
};

///ファイルまたはメモリからテクスチャを生成する
class ITextureBuilder{
	protected:
		ITextureBuilder(){};
	private:
		ITextureBuilder(const ITextureBuilder&);
		ITextureBuilder& operator=(const ITextureBuilder&);
	public:
		static ITextureBuilder& Instance();
		virtual ~ITextureBuilder(){}
		virtual ITexture* CreateTextureFromFile(const char* filepath)=0;
		virtual ITexture* CreateTextureFromFile(const wchar_t* filepath)=0;
		virtual ITexture* CreateTextureFromMemory(const void* data)=0;
};
}//end of namespace KFX
#endif
