﻿///@brief
///@date 2011/03/14 14:02:42(月)
#ifndef KFX_IPERIPHERAL_H
#define KFX_IPERIPHERAL_H
#include<vector>
#include"../kernel/pointer/shared_ptr.h"
namespace KFX{

class KInputListener;

///生入力→ゲーム用入力基底クラス
///とりあえず1P～4Pまで利用される可能性を考慮
///もちろん、数によらない実装を行うが、テストや実装時の心配は
///通常1P～4Pまでで十分だろう…。
///特にキーボード時のユーザー数は２まででよい
class IPeripheral{
	private:
		IPeripheral(const IPeripheral&);
		IPeripheral& operator=(const IPeripheral&);
	protected:
		typedef std::vector<KInputListener*> listeners_t;
		listeners_t _listeners;//弱参照ポインタの配列として扱う
	public:
		IPeripheral(){}
		///方向
		enum DirectionState{
			DS_NEUTRAL=0,
			DS_LEFTDOWN,
			DS_DOWN,
			DS_RIGHTDOWN,
			DS_RIGHT,
			DS_RIGHTUP,
			DS_UP,
			DS_LEFTUP,
			DS_LEFT
		};
		///押されている判定
		enum GameButtons{
			GB_LEFT=0,
			GB_DOWN,
			GB_RIGHT,
			GB_UP,
			GB_BUTTON_A,
			GB_BUTTON_B,
			GB_BUTTON_C,
			GB_BUTTON_D,
			GB_BUTTON_E,
			GB_BUTTON_F,
		};
		enum GameButtonMasks{
			GBMASK_LEFT=1<<GB_LEFT,
			GBMASK_DOWN=1<<GB_DOWN,
			GBMASK_RIGHT=1<<GB_RIGHT,
			GBMASK_UP=1<<GB_UP,
			GBMASK_BUTTON_A=1<<GB_BUTTON_A,
			GBMASK_BUTTON_B=1<<GB_BUTTON_B,
			GBMASK_BUTTON_C=1<<GB_BUTTON_C,
			GBMASK_BUTTON_D=1<<GB_BUTTON_D,
			GBMASK_BUTTON_E=1<<GB_BUTTON_E,
			GBMASK_BUTTON_F=1<<GB_BUTTON_F,
		};
		enum AnalogInputType{
			THUMB_LX,
			THUMB_LY,
			THUMB_RX,
			THUMB_RY,
			LEFT_TRIGGER,
			RIGHT_TRIGGER,
		};
		typedef unsigned long long InputStatus;
		///入力に反応するものとバインドする
		///@param listener バインドしたいオブジェクト
		///@param id パッドID(キーボード等は関係ない)
		void AddListener(KInputListener* listener,int id=0);
		virtual bool IsPressed(GameButtons buttons,int id=0)const=0;
		virtual int AnalogValue(AnalogInputType type,int id=0)const=0;
		virtual DirectionState CurrentDirection(int id=0)const=0;
		virtual const InputStatus& CurrentInputStatus(int id=0)const=0;

		///既にバインド済みであるか？
		///@retval true バインド済み
		///@retval false バインドされていない
		virtual bool IsBinded()const=0;

		
		///入力チェック
		///@remarks 入力を有効にしたい場合は、マイフレーム呼び出されなければならないが、
		///クライアントが直接呼び出す必要はない
		virtual void CheckInput()=0;
};

class KPeripheralListHolder{
	std::vector<SharedPtr<IPeripheral> > _periphList;
	KPeripheralListHolder();
	KPeripheralListHolder(const KPeripheralListHolder& );
	KPeripheralListHolder& operator=(const KPeripheralListHolder& );
public:
	static KPeripheralListHolder& Instance(){
		static KPeripheralListHolder instance;
		return instance;
	}
	std::vector<SharedPtr<IPeripheral> >& PeriphList();
};

class KInputListener{
public:
	virtual void OnPressed(IPeripheral& periph)=0;
};

}//end of namespace KFX
#endif
