﻿#ifndef KFX_DEVICE_WRAPPER_H_INCLUDED
#define KFX_DEVICE_WRAPPER_H_INCLUDED
#include"../pointer/scoped_ptr.h"
#include"../pointer/shared_ptr.h"
namespace KFX{

#ifdef _WINDOWS
#define nullptr
#endif

class RootNode;
class GameNode;

///ウィンドウ周りラッパ
///Windowsではコンストラクタ時にウィンドウの作成までやってしまう
class KWindow{
	void* _handle;
	KWindow() : _handle(nullptr){}
public:
	static KWindow& Instance();
	void* Handle() const{
		return _handle;
	}
};

///各種(Win32,XBox360,PS3等)デバイスラッパ
class KDeviceWrapper{
	protected:
		void* _dev;
		ScopedPtr<RootNode> _rootnode;
		KDeviceWrapper();
		//コピー、代入禁止
		KDeviceWrapper(const KDeviceWrapper&);
		KDeviceWrapper& operator=(const KDeviceWrapper&);
	public:
		virtual void Update();
		///ゲームノードの追加
		void AddGameNode(GameNode& gamenode);

		static KDeviceWrapper& Instance();

		///デバイス使用できる状態か？
		///@retval true デバイスラッパ利用可能
		virtual bool IsAvailable() const=0;

		///個別プラットフォームのデバイスラッパへのポインタを返す
		///@return デバイスのポインタ
		void* GetDevice()const;
		
};

}//end of namespace KFX

#endif                   
