/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

//
//  Copyright (C) 2007 Hiroyuki Ikezoe
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif /* HAVE_CONFIG_H */

#include <glib/gi18n.h>
#include "kz-gecko-single.h"
#include "kz-app.h"
#include "mozilla.h"

enum
{
	PROP_0,
	PROP_KZ_APP
};

typedef struct _KzGeckoSinglePrivate	KzGeckoSinglePrivate;
struct _KzGeckoSinglePrivate
{
	KzApp *kz_app;
};

#define KZ_GECKO_SINGLE_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), KZ_TYPE_GECKO_SINGLE, KzGeckoSinglePrivate))

static GObject *constructor  (GType type,
                              guint n_props,
                              GObjectConstructParam *props);
static void     dispose      (GObject *object);
static void     set_property (GObject *object,
                              guint prop_id,
                              const GValue *value,
                              GParamSpec *pspec);
static void     get_property (GObject *object,
                              guint prop_id,
                              GValue *value,
                              GParamSpec *pspec);

static KzGeckoSingle    *the_kz_gecko_single = NULL;

G_DEFINE_TYPE(KzGeckoSingle, kz_gecko_single, G_TYPE_OBJECT)

static void
kz_gecko_single_class_init (KzGeckoSingleClass *klass)
{
	GObjectClass *object_class;

	kz_gecko_single_parent_class = g_type_class_peek_parent (klass);
	object_class = (GObjectClass *) klass;

	object_class->constructor  = constructor;
	object_class->dispose	   = dispose;
	object_class->set_property = set_property;
	object_class->get_property = get_property;

	g_object_class_install_property(
		object_class,
		PROP_KZ_APP,
		g_param_spec_object ("kz-app",
				      _("KzApp"),
				      _("The KzApp object"),
				      KZ_TYPE_APP,
				     (GParamFlags)  (G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY)));
	g_type_class_add_private(object_class, sizeof(KzGeckoSinglePrivate));
}

static GObject *
constructor (GType                  type,
             guint                  n_props,
             GObjectConstructParam *props)
{
	GObject *object;

	if (!the_kz_gecko_single) 
	{
		KzGeckoSinglePrivate *priv;
		GObjectClass *klass = G_OBJECT_CLASS(kz_gecko_single_parent_class);
		object = klass->constructor(type, n_props, props);

		the_kz_gecko_single = KZ_GECKO_SINGLE(object);

		priv = KZ_GECKO_SINGLE_GET_PRIVATE(object);
		mozilla_init(kz_app_get_profile(priv->kz_app));
	}
	else
	{
		object = G_OBJECT(g_object_ref(G_OBJECT(the_kz_gecko_single)));
	}
	return object;
}

static void
set_property (GObject *object,
              guint prop_id,
              const GValue *value,
              GParamSpec *pspec)
{
	KzGeckoSinglePrivate *priv = KZ_GECKO_SINGLE_GET_PRIVATE(object);

	switch (prop_id)
	{
	case PROP_KZ_APP:
		priv->kz_app = KZ_APP(g_object_ref(g_value_get_object(value)));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}


static void
get_property (GObject *object,
              guint prop_id,
              GValue *value,
              GParamSpec *pspec)
{
	KzGeckoSinglePrivate *priv = KZ_GECKO_SINGLE_GET_PRIVATE(object);

	switch (prop_id)
	{
	case PROP_KZ_APP:
		g_value_set_object(value, priv->kz_app);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}


static void
kz_gecko_single_init (KzGeckoSingle *single)
{
	KzGeckoSinglePrivate *priv = KZ_GECKO_SINGLE_GET_PRIVATE(single);

	priv->kz_app = NULL;
}


static void
dispose (GObject *object)
{
	KzGeckoSinglePrivate *priv = KZ_GECKO_SINGLE_GET_PRIVATE(object);

	if (priv->kz_app)
	{
		mozilla_exit();
		g_object_unref(priv->kz_app);
	}

	priv->kz_app = NULL;
	
	if (G_OBJECT_CLASS (kz_gecko_single_parent_class)->dispose)
		G_OBJECT_CLASS (kz_gecko_single_parent_class)->dispose(object);
}


KzGeckoSingle *
kz_gecko_single_new (KzApp *kz_app)
{
	KzGeckoSingle *single = KZ_GECKO_SINGLE(g_object_new(KZ_TYPE_GECKO_SINGLE,
				    "kz-app", kz_app,
				    NULL));

	return single;
}

