/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_session.h"

#include <string.h>
#include <glib/gi18n.h>
#include "kazehakase.h"
#include "utils/gtk-utils.h"


#define DATA_KEY "KzPrefsSession::info"


static GtkWidget     *prefs_session_create      (void);
static void           prefs_session_response    (GtkWidget *widget,
						 gint       response);


static KzPrefsWinPageEntry prefs_entry =
{
	/* .path          = */ N_("/Session"),
	/* .priority_hint = */ 0,
	/* .ui_level      = */ KZ_UI_LEVEL_EXPERT,
	/* .create        = */ prefs_session_create,
	/* .response      = */ prefs_session_response,
};


typedef struct _KzPrefsSession
{
	GtkWidget     *main_vbox;
	GtkWidget     *save_check;
	GtkWidget     *restore_check;
	gboolean       changed;
} KzPrefsSession;



static void
cb_changed (GtkWidget *widget, KzPrefsSession *prefsui)
{
	prefsui->changed = TRUE;
}


static void
prefs_session_destroy (gpointer data)
{
	KzPrefsSession *prefsui = data;

	g_free(prefsui);
}


static GtkWidget *
prefs_session_create (void)
{
	KzPrefsSession *prefsui = g_new0(KzPrefsSession, 1);
	GtkWidget *main_vbox;
	GtkWidget *label, *check;
	gboolean save, restore;

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_session_destroy);

	label = kz_prefs_ui_utils_create_title(_("Session"));
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);


	/*
	 *  Save/Restore
	 */
	check = gtk_check_button_new_with_mnemonic(_("_Save session"));
	prefsui->save_check = check;
	gtk_box_pack_start(GTK_BOX(main_vbox), check, FALSE, FALSE, 2);
	save = TRUE;
	KZ_CONF_GET("Session", "save", save, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), save);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	check = gtk_check_button_new_with_mnemonic(_("_Restore session"));
	prefsui->restore_check = check;
	gtk_box_pack_start(GTK_BOX(main_vbox), check, FALSE, FALSE, 2);
	restore = TRUE;
	KZ_CONF_GET("Session", "restore", restore, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), restore);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);


	prefsui->changed = FALSE;

	return main_vbox;
}


static void
prefs_session_response (GtkWidget *widget, gint response)
{
	KzPrefsSession *prefsui = g_object_get_data(G_OBJECT(widget), DATA_KEY);

	g_return_if_fail(prefsui);

	switch (response) {
	case GTK_RESPONSE_ACCEPT:
	case GTK_RESPONSE_APPLY:
	{
		gboolean save, restore;

		if (!prefsui->changed)
			break;

		save = gtk_toggle_button_get_active
		       (GTK_TOGGLE_BUTTON(prefsui->save_check));
		KZ_CONF_SET("Session", "save", save, BOOL);

		restore = gtk_toggle_button_get_active
			  (GTK_TOGGLE_BUTTON(prefsui->restore_check));
		KZ_CONF_SET("Session", "restore", restore, BOOL);

		prefsui->changed = FALSE;

		break;
	}
	case GTK_RESPONSE_REJECT:
		break;
	case KZ_RESPONSE_UI_LEVEL_MEDIUM:
		break;
	case KZ_RESPONSE_UI_LEVEL_EXPERT:
		break;
	case KZ_RESPONSE_UI_LEVEL_CUSTOM:
		break;
	default:
		break;
	}
}


KzPrefsWinPageEntry *
prefs_session_get_entry (gint idx)
{
	if (idx == 0)
		return &prefs_entry;
	else
		return NULL;
}
