/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2006 Kouhei Sutou <kou@cozmixng.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_EXT_IMPL_H__
#define __KZ_EXT_IMPL_H__

#include <glib.h>

G_BEGIN_DECLS

#include "kz-app.h"
#include "kz-window.h"

typedef void (*KzExtInitFunc)  (KzApp *app, void *init_address);
typedef void (*KzExtSetupFunc) (KzWindow *window);
typedef void (*KzExtExitFunc)  (gboolean success);

#define KZ_EXT_IMPL_INIT        kz_ext_impl_init
#define KZ_EXT_IMPL_SETUP       kz_ext_impl_setup
#define KZ_EXT_IMPL_EXIT        kz_ext_impl_exit


void	KZ_EXT_IMPL_INIT		(KzApp *app, void *init_address);
void	KZ_EXT_IMPL_SETUP		(KzWindow *kz);
void	KZ_EXT_IMPL_EXIT		(gboolean success);

G_END_DECLS

#endif /* __KZ_EXT_IMPL_H__ */
