/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __KZ_BOOKMARK_FOLDER_H__
#define __KZ_BOOKMARK_FOLDER_H__

#include "kz-bookmark-objects.h"
#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_FOLDER		(kz_bookmark_folder_get_type ())
#define KZ_BOOKMARK_FOLDER(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_FOLDER, KzBookmarkFolder))
#define KZ_BOOKMARK_FOLDER_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_BOOKMARK_FOLDER, KzBookmarkFolderClass))
#define KZ_IS_BOOKMARK_FOLDER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_FOLDER))
#define KZ_IS_BOOKMARK_FOLDER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_BOOKMARK_FOLDER))
#define KZ_BOOKMARK_FOLDER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_BOOKMARK_FOLDER, KzBookmarkFolderClass))

typedef struct _KzBookmarkFolderClass    KzBookmarkFolderClass;

#define KZ_BOOKMARK_FOLDER_SORT_LAST_MODIFIED "last-modified"

struct _KzBookmarkFolder
{
	KzBookmark parent;
};

struct _KzBookmarkFolderClass
{
	KzBookmarkClass parent_class;

	/* -- signals -- */
	void (*insert_child)       (KzBookmarkFolder  *folder,
				    KzBookmark        *child,
				    KzBookmark        *sibling);
	void (*remove_child)       (KzBookmarkFolder  *folder,
				    KzBookmark        *child);
	void (*move_child)         (KzBookmarkFolder  *folder,
				    KzBookmarkFolder  *parent,
				    KzBookmark        *sibling);
	void (*children_reordered) (KzBookmarkFolder  *boomark);

	GList    *(*get_children)  (KzBookmarkFolder  *boomark);
	gboolean  (*has_children)  (KzBookmarkFolder  *boomark);
};

/* GType */
GType		kz_bookmark_folder_get_type		(void) G_GNUC_CONST; 

/* boomark item creating functions */
KzBookmark     *kz_bookmark_folder_new		        (const gchar *title);

gboolean	kz_bookmark_folder_get_folded		(KzBookmarkFolder  *folder);
void		kz_bookmark_folder_set_folded		(KzBookmarkFolder  *folder,
							 gboolean     folded);
void		kz_bookmark_folder_insert_before	(KzBookmarkFolder  *folder,
						 	 KzBookmark *child,
						 	 KzBookmark *sibling);
void		kz_bookmark_folder_append		(KzBookmarkFolder  *folder,
						 	 KzBookmark         *child);
void		kz_bookmark_folder_prepend		(KzBookmarkFolder  *folder,
						 	 KzBookmark        *child);
void		kz_bookmark_folder_remove		(KzBookmarkFolder  *folder,
						 	 KzBookmark        *child);
void		kz_bookmark_folder_remove_all		(KzBookmarkFolder  *folder);
GList	       *kz_bookmark_folder_get_children		(KzBookmarkFolder  *folder);
gboolean        kz_bookmark_folder_has_children         (KzBookmarkFolder  *folder);
void		kz_bookmark_folder_sort			(KzBookmarkFolder  *folder,
						 	 const gchar *type);
guint		kz_bookmark_folder_get_current_position	(KzBookmarkFolder  *folder);
void		kz_bookmark_folder_set_current_position	(KzBookmarkFolder  *folder,
						 	 guint pos);
gboolean	kz_bookmark_folder_get_lock		(KzBookmarkFolder  *folder);
void		kz_bookmark_folder_set_lock		(KzBookmarkFolder  *folder,
						 	 gboolean lock);
gboolean	kz_bookmark_folder_get_auto_refresh	(KzBookmarkFolder  *folder);
void		kz_bookmark_folder_set_auto_refresh	(KzBookmarkFolder  *folder,
						 	 gboolean auto_refresh);
gboolean	kz_bookmark_folder_get_javascript	(KzBookmarkFolder  *folder);
void		kz_bookmark_folder_set_javascript	(KzBookmarkFolder  *folder,
						 	 gboolean javascript);

void		kz_bookmark_folder_register_sort_func	(const gchar *type,
						 	 GCompareFunc *func);

KzBookmark     *kz_bookmark_folder_get_current_bookmark (KzBookmarkFolder  *folder);
KzBookmark     *kz_bookmark_folder_find_bookmark_from_uri 
							(KzBookmarkFolder  *folder,
							 const gchar *key_uri);
void            kz_bookmark_folder_foreach_child        (KzBookmarkFolder  *folder,
							 GFunc       func,
							 gpointer    user_data);
KzBookmark     *kz_bookmark_folder_get_nth_child        (KzBookmarkFolder  *folder,
							 gint index);
gint 		kz_bookmark_folder_get_child_index	(KzBookmarkFolder  *folder,
							 KzBookmark *child);
G_END_DECLS

#endif /* __KZ_BOOKMARK_FOLDER_H__ */
