/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-downloader-sidebar.h 1898 2005-02-06 11:24:26Z ikezoe $
 */

#include "kz-sidebar.h"

#include "kz-downloader-group.h"

#ifndef __KZ_DOWNLOADER_SIDEBAR_H__
#define __KZ_DOWNLOADER_SIDEBAR_H__

#define KZ_TYPE_DOWNLOADER_SIDEBAR		(kz_downloader_sidebar_get_type ())
#define KZ_DOWNLOADER_SIDEBAR(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_DOWNLOADER_SIDEBAR, KzDownloaderSidebar))
#define KZ_DOWNLOADER_SIDEBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_DOWNLOADER_SIDEBAR, KzDownloaderSidebarClass))
#define KZ_IS_DOWNLOADER_SIDEBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_DOWNLOADER_SIDEBAR))
#define KZ_IS_DOWNLOADER_SIDEBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_DOWNLOADER_SIDEBAR))
#define KZ_DOWNLOADER_SIDEBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_DOWNLOADER_SIDEBAR, KzDownloaderSidebarClass))

typedef struct _KzDownloaderSidebar		KzDownloaderSidebar;
typedef struct _KzDownloaderSidebarClass	KzDownloaderSidebarClass;
typedef struct _KzDownloaderSidebarPriv		KzDownloaderSidebarPriv;
typedef struct _KzDownloaderSidebarItem		KzDownloaderSidebarItem;

struct _KzDownloaderSidebar
{
	GtkVBox          parent;

	KzSidebar         *sidebar;
	KzDownloaderGroup *downloader_group;
	GtkWidget         *tree_view;

	KzDownloaderSidebarPriv *priv;
};

struct _KzDownloaderSidebarClass
{
	GtkVBoxClass parent_class;
};

KzSidebarEntry   *kz_downloader_sidebar_get_entry (gint idx);

GType	          kz_downloader_sidebar_get_type  (void) G_GNUC_CONST;
GtkWidget        *kz_downloader_sidebar_new       (KzSidebar *sidebar);

#endif /* __KZ_DOWNLOADER_SIDEBAR_H__ */
