/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-actions-tab.h"

#include <string.h>
#include "egg-action.h"
#include "gtk-utils.h"
#include "intl.h"

static void
act_tab_reload (EggAction *action, KzTabLabel *kztab)
{
	g_return_if_fail(KZ_IS_TAB_LABEL(kztab));

	gtk_moz_embed_reload(GTK_MOZ_EMBED(kztab->kzembed),
			     GTK_MOZ_EMBED_FLAG_RELOADNORMAL);
}

static void
act_tab_stop (EggAction *action, KzTabLabel *kztab)
{
	g_return_if_fail(KZ_IS_TAB_LABEL(kztab));

	gtk_moz_embed_stop_load(GTK_MOZ_EMBED(kztab->kzembed));
}

static void
act_tab_close (EggAction *action, KzTabLabel *kztab)
{
	g_return_if_fail(KZ_IS_TAB_LABEL(kztab));

	kz_window_close_tab(kztab->kz, GTK_WIDGET(kztab->kzembed));
}

static void
close_all_tab (EggAction *action, KzTabLabel *kztab, gint mode)
{
	GtkNotebook *notebook;
	gint num, pos;
	gint i;

	g_return_if_fail(KZ_IS_TAB_LABEL(kztab));
	notebook = GTK_NOTEBOOK(kztab->kz->notebook);

	num = gtkutil_notebook_get_n_pages(notebook);
	pos = gtk_notebook_page_num(notebook, GTK_WIDGET(kztab->kzembed));

	if (num < 2 || pos < 0) return;

	for (i = num - 1; i >= 0; i--)
	{
		GtkWidget *widget = KZ_WINDOW_NTH_PAGE(kztab->kz, i);

		if (i == pos) continue;
		if (i > pos && mode == 1) continue;
		if (i < pos && mode == 2) continue;

		kz_window_close_tab_idle(kztab->kz, widget);
	}
}

static void
act_tab_close_left (EggAction *action, KzTabLabel *kztab)
{
	g_return_if_fail(KZ_IS_TAB_LABEL(kztab));
	close_all_tab(action, kztab, 1);
}

static void
act_tab_close_right (EggAction *action, KzTabLabel *kztab)
{
	close_all_tab(action, kztab, 2);
}

static void
act_tab_close_all_without_active (EggAction *action, KzTabLabel *kztab)
{
	close_all_tab(action, kztab, 0);
}

static void
act_tab_copy_title (EggAction *action, KzTabLabel *kztab)
{
	g_return_if_fail(KZ_IS_TAB_LABEL(kztab));

	gtkutil_copy_text(kz_moz_embed_get_title(KZ_MOZ_EMBED(kztab->kzembed)));
}

static void
act_tab_copy_location (EggAction *action, KzTabLabel *kztab)
{
	g_return_if_fail(KZ_IS_TAB_LABEL(kztab));

	gtkutil_copy_text(kz_moz_embed_get_location(KZ_MOZ_EMBED(kztab->kzembed)));
}

static void
act_tab_copy_title_and_location (EggAction *action, KzTabLabel *kztab)
{
	g_return_if_fail(KZ_IS_TAB_LABEL(kztab));

	gchar *str = g_strdup_printf("<a href=\"%s\" title=\"%s\">%s</a>",
				     kz_moz_embed_get_location(KZ_MOZ_EMBED(kztab->kzembed)),
				     kz_moz_embed_get_title(KZ_MOZ_EMBED(kztab->kzembed)),
				     kz_moz_embed_get_title(KZ_MOZ_EMBED(kztab->kzembed)));
	gtkutil_copy_text(str);
	g_free(str);
}

EggActionGroupEntry kz_actions_tab[] =
{
        /* Toplevel */
        { "FakeToplevel", (""), NULL, NULL, NULL, NULL, NULL },

	{"TabReload",        N_("Reloa_d"),
	 GTK_STOCK_REFRESH, NULL, NULL, G_CALLBACK(act_tab_reload), NULL},

	{"TabStop",          N_("_Stop"),
	 GTK_STOCK_STOP, NULL, NULL, G_CALLBACK(act_tab_stop), NULL},

	{"TabClose",         N_("_Close"),
	 GTK_STOCK_CLOSE, NULL, NULL, G_CALLBACK(act_tab_close), NULL},

	{"TabCloseAllLeft",  N_("Close all _left tab"),
	 GTK_STOCK_CLOSE, NULL, NULL, G_CALLBACK(act_tab_close_left), NULL},

	{"TabCloseAllRight", N_("Close all _right tab"), 
	 GTK_STOCK_CLOSE, NULL, NULL, G_CALLBACK(act_tab_close_right), NULL},

	{"TabCloseAllWithoutActive", N_("Close all _right tab"),
	 GTK_STOCK_CLOSE, NULL, NULL, G_CALLBACK(act_tab_close_all_without_active), NULL},

	{"TabCopyTitle",        N_("Copy _Title"),
	 GTK_STOCK_COPY, NULL, NULL, G_CALLBACK(act_tab_copy_title), NULL},

	{"TabCopyLocation",     N_("Copy _Location"),
	 GTK_STOCK_COPY, NULL, NULL, G_CALLBACK(act_tab_copy_location), NULL},

	{"TabCopyTitleLocation",     N_("Copy Title&Location"),
	 GTK_STOCK_COPY, NULL, NULL, G_CALLBACK(act_tab_copy_title_and_location), NULL},
};
const gint kz_actions_tab_len = G_N_ELEMENTS(kz_actions_tab);


static void
cb_popup_menu_hide (void)
{
	gtk_main_quit();
}


void
kz_actions_tab_popup_menu_modal (KzTabLabel *kztab, guint button, guint time)
{
	GtkWidget *popup_menu = NULL;

	popup_menu = egg_menu_merge_get_widget(kztab->kz->menu_merge,
					       "/popups/TabPopup");
	if (!popup_menu) return;

	g_signal_connect(G_OBJECT(popup_menu), "hide",
			 G_CALLBACK(cb_popup_menu_hide), kztab);
	gtk_menu_popup(GTK_MENU(popup_menu), NULL, NULL,
		       NULL, NULL, button, time);
	gtk_main();
	g_signal_handlers_disconnect_by_func(G_OBJECT(popup_menu),
					     G_CALLBACK(cb_popup_menu_hide), kztab);
}
