/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <time.h>
#include <gtk/gtk.h>

#include "gobject-utils.h"
#include "intl.h"
#include "kz-lirs.h"

static void     kz_lirs_class_init      (KzLIRSClass *klass);
static void     kz_lirs_init            (KzLIRS *lirs);
/* static void     kz_lirs_dispose         (GObject *object); */

static void     kz_lirs_parse_from_string (KzMETA *meta, gpointer user_data,
					   const gchar *buffer, guint length,
					   GError **error);

static KzMETAClass *parent_class = NULL;

KZ_OBJECT_GET_TYPE(kz_lirs, "KzLIRS", KzLIRS,
		   kz_lirs_class_init, kz_lirs_init,
		   KZ_TYPE_META)

static void
kz_lirs_class_init (KzLIRSClass *klass)
{
	GObjectClass *object_class;
	KzMETAClass *meta_class;

	parent_class = g_type_class_peek_parent (klass);
	object_class = (GObjectClass *) klass;
	meta_class   = (KzMETAClass *) klass;

	meta_class->kz_meta_parse_from_string = kz_lirs_parse_from_string;
}

static void
kz_lirs_init (KzLIRS *lirs)
{
	lirs->antenna_uri = NULL;
}

KzLIRS *
kz_lirs_new (gchar *uri, gchar *title, guint update_interval)
{
	KzLIRS *lirs = KZ_LIRS(g_object_new(KZ_TYPE_LIRS,
					 "uri", uri,
					 "title", title,
					 "interval", update_interval,
					 NULL));
	kz_meta_update((KzMETA*)lirs);

	return lirs;
}


static gint 
compare_func (gconstpointer a, gconstpointer b)
{
	guint one = ((KzMETAItem*)a)->date;
	guint two = ((KzMETAItem*)b)->date;
	return two-one;
}


static gchar  **
kz_strsplit (const gchar *string,
	    const gchar *delimiter,
	    gint         max_tokens)
{
	GSList *string_list = NULL, *slist;
	gchar **str_array, *s;
	guint n = 0;
	const gchar *remainder;

	g_return_val_if_fail (string != NULL, NULL);
	g_return_val_if_fail (delimiter != NULL, NULL);
	g_return_val_if_fail (delimiter[0] != '\0', NULL);

	if (max_tokens < 1)
		max_tokens = G_MAXINT;

	remainder = string;
	s = strstr (remainder, delimiter);
	if (s)
	{
		gsize delimiter_len = strlen (delimiter);   

		while (--max_tokens && s)
		{
			gsize len;     
			gchar *new_string;
/*			
			if (*(s - 1) = '\\')
			{
				new_string = s + delimiter_len;
				s = strstr (new_string, delimiter);
			}
*/
			len = s - remainder;
			new_string = g_new (gchar, len + 1);
			strncpy (new_string, remainder, len);
			new_string[len] = 0;
			string_list = g_slist_prepend (string_list, new_string);
			n++;
			remainder = s + delimiter_len;
			s = strstr (remainder, delimiter);
		}
	}
	if (*string)
	{
		n++;
		string_list = g_slist_prepend (string_list, g_strdup (remainder));
	}

	str_array = g_new (gchar*, n + 1);

	str_array[n--] = NULL;
	for (slist = string_list; slist; slist = slist->next)
		str_array[n--] = slist->data;

	g_slist_free (string_list);

	return str_array;
}

static void
kz_lirs_parse_from_string (KzMETA *meta, gpointer user_data,
			   const gchar *buffer, guint length,
			   GError **error)
{
	gchar *dest = NULL;
	guint read_len, dest_len;
	gchar **lines    = NULL;
	gchar **elements = NULL;
	guint line_number = 0;
	gchar timestr[20];
	struct tm *t = NULL;

	g_return_if_fail(buffer != NULL);

	/* convert to utf-8 encoding */
	dest = g_convert(buffer, length, "UTF-8", "EUC-JP",
			 &read_len, &dest_len, NULL);

	lines = g_strsplit(dest, "\n", -1);
	
	while (lines[line_number+1] != NULL)
	{
		KzMETAItem *item;

		elements = kz_strsplit(lines[line_number], ",", 8);
		item = g_new0(KzMETAItem, 1);
		item->meta = meta;
		/* Last-Modified */
		item->date  = atoi(elements[1]) + atoi(elements[3]); /* adding time difference */
		t = (struct tm*)gmtime((time_t*)(&(item->date)));
		strftime(timestr, 20, "%Y/%m/%d %H:%M", t);
		if (elements[6]) /* Title */
			item->title = g_strdup_printf("%s %s",timestr, elements[6]);
		if (elements[5]) /* URL */
			item->link  = g_strdup(elements[5]);
		
		g_strfreev(elements);

		if (!meta->items)
			meta->items = g_slist_append(meta->items, item);
		else
			g_slist_append(meta->items,item);

		line_number++;
	}

	g_strfreev(lines);
	
	/* sorting */
	meta->items = g_slist_sort(meta->items, compare_func);
}
