/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_HTTP_H__
#define __KZ_HTTP_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define KZ_TYPE_HTTP		(kz_http_get_type ())
#define KZ_HTTP(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_HTTP, KzHTTP))
#define KZ_HTTP_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_HTTP, KzHTTPClass))
#define KZ_IS_HTTP(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_HTTP))
#define KZ_IS_HTTP_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_HTTP))
#define KZ_HTTP_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_HTTP, KzHTTPClass))

typedef struct _KzHTTP KzHTTP;
typedef struct _KzHTTPClass KzHTTPClass;

struct _KzHTTP
{
	GObject parent;
	
	gchar *uri;
	gchar *hostname;
	gchar *path;

	gboolean header;
	gboolean use_proxy;
	
	guint content_length;
	GString *buf;
};

struct _KzHTTPClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*fetch_completed)     (KzHTTP *http);
};

KzHTTP *kz_http_new    (gchar *uri);
void kz_http_file_fetch(KzHTTP *http);
void kz_http_dispose   (GObject *object);

G_END_DECLS

#endif /* __KZ_HTTP_H__ */
