/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef KZ_SMART_BOOKMARK_BUTTON_ACTION_H
#define KZ_SMART_BOOKMARK_BUTTON_ACTION_H

#include <gtk/gtk.h>

#include "kz-bookmark.h"
#include "kz-window.h"

#define KZ_TYPE_SMART_BOOKMARK_BUTTON_ACTION            (kz_smart_bookmark_button_action_get_type())
#define KZ_SMART_BOOKMARK_BUTTON_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), KZ_TYPE_SMART_BOOKMARK_BUTTON_ACTION, KzSmartBookmarkButtonAction))
#define KZ_SMART_BOOKMARK_BUTTON_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), KZ_TYPE_SMART_BOOKMARK_BUTTON_ACTION, KzSmartBookmarkButtonActionClass))
#define KZ_IS_SMART_BOOKMARK_BUTTON_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), KZ_TYPE_SMART_BOOKMARK_BUTTON_ACTION))
#define KZ_IS_SMART_BOOKMARK_BUTTON_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((obj), KZ_TYPE_SMART_BOOKMARK_BUTTON_ACTION))
#define KZ_SMART_BOOKMARK_BUTTON_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), KZ_TYPE_SMART_BOOKMARK_BUTTON_ACTION, KzSmartBookmarkButtonActionClass))

typedef struct _KzSmartBookmarkButtonAction      KzSmartBookmarkButtonAction;
typedef struct _KzSmartBookmarkButtonActionClass KzSmartBookmarkButtonActionClass;

struct _KzSmartBookmarkButtonAction
{
	GtkAction   parent;

	KzBookmark *bookmark;
	KzWindow   *kz;
};

struct _KzSmartBookmarkButtonActionClass
{
	GtkActionClass parent_class;
};

GType         kz_smart_bookmark_button_action_get_type (void);
KzSmartBookmarkButtonAction *kz_smart_bookmark_button_action_new
				(KzWindow   *kz,
	 			 KzBookmark *bookmark);

#endif /* KZ_SMART_BOOKMARK_BUTTON_ACTION_H */
