/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-action.h 453 2003-11-11 23:44:29Z makeinu $
 */

#ifndef __KZ_BOOKMARK_ACTION_H__
#define __KZ_BOOKMARK_ACTION_H__

#include <gtk/gtk.h>
#include "egg-action.h"
#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_ACTION			(kz_bookmark_action_get_type ())
#define KZ_BOOKMARK_ACTION(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_ACTION, KzBookmarkAction))
#define KZ_BOOKMARK_ACTION_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_BOOKMARK_ACTION, KzBookmarkActionClass))
#define KZ_IS_BOOKMARK_ACTION(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_ACTION))
#define KZ_IS_BOOKMARK_ACTION_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_BOOKMARK_ACTION))
#define KZ_BOOKMARK_ACTION_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_BOOKMARK_ACTION, KzBookmarkActionClass))

typedef struct _KzBookmarkAction	KzBookmarkAction;
typedef struct _KzBookmarkActionClass	KzBookmarkActionClass;
typedef struct _KzBookmarkActionPriv	KzBookmarkActionPriv;

struct _KzBookmarkAction
{
	EggAction   parent;

	KzBookmarkActionPriv *priv;
};

struct _KzBookmarkActionClass
{
	EggActionClass parent_class;
};

GtkType    kz_bookmark_action_get_type     (void);

G_END_DECLS

#endif /* __KZ_BOOKMARK_ACTION_H__ */
